/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.aop.Aspect;
import io.avaje.inject.generator.AspectPair;
import io.avaje.inject.generator.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

class AspectAnnotationReader {
    private static final String ASPECT = "io.avaje.inject.aop.Aspect";
    private final TypeElement baseType;
    private final Element element;
    private final ProcessingContext context;

    AspectAnnotationReader(ProcessingContext context, TypeElement baseType, Element element) {
        this.context = context;
        this.baseType = baseType;
        this.element = element;
    }

    List<AspectPair> read() {
        ArrayList<AspectPair> aspects = new ArrayList<AspectPair>();
        for (AnnotationMirror annotationMirror : this.element.getAnnotationMirrors()) {
            Meta meta;
            Element anElement = annotationMirror.getAnnotationType().asElement();
            Aspect aspect = anElement.getAnnotation(Aspect.class);
            if (aspect == null || (meta = this.readTarget(anElement)) == null) continue;
            aspects.add(new AspectPair(anElement, meta.target, meta.ordering));
        }
        return aspects;
    }

    private Meta readTarget(Element anElement) {
        for (AnnotationMirror annotationMirror : anElement.getAnnotationMirrors()) {
            if (!ASPECT.equals(annotationMirror.getAnnotationType().toString())) continue;
            Meta meta = new Meta();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                String key = entry.getKey().toString();
                if (key.equals("target()")) {
                    meta.target(entry.getValue().getValue().toString());
                    continue;
                }
                if (!key.equals("ordering()")) continue;
                meta.ordering(Integer.parseInt(entry.getValue().getValue().toString()));
            }
            return meta;
        }
        this.context.logError(this.baseType + " aspect target() not found on " + this.element, new Object[0]);
        return null;
    }

    private static class Meta {
        String target;
        int ordering = 1000;

        private Meta() {
        }

        void target(String target) {
            this.target = target;
        }

        void ordering(int ordering) {
            this.ordering = ordering;
        }

        public String toString() {
            return "Meta(target=" + this.target + ", ordering=" + this.ordering + ")";
        }
    }
}

