/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AspectMethod;
import io.avaje.inject.generator.Util;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class BeanAspects {
    static final BeanAspects EMPTY = new BeanAspects();
    private final List<AspectMethod> aspectMethods;
    private final Set<String> targets;

    private BeanAspects() {
        this.aspectMethods = Collections.emptyList();
        this.targets = Collections.emptySet();
    }

    BeanAspects(List<AspectMethod> aspectMethods) {
        this.aspectMethods = aspectMethods;
        this.targets = this.initTargets();
    }

    boolean hasAspects() {
        return !this.aspectMethods.isEmpty();
    }

    Set<String> targets() {
        return this.targets;
    }

    void extraImports(Set<String> importTypes) {
        for (AspectMethod aspectMethod : this.aspectMethods) {
            aspectMethod.addImports(importTypes);
        }
    }

    Set<String> initTargets() {
        LinkedHashSet<String> targets = new LinkedHashSet<String>();
        for (AspectMethod aspectMethod : this.aspectMethods) {
            aspectMethod.addTargets(targets);
        }
        return targets;
    }

    void writeFields(Append writer) {
        for (String target : this.targets) {
            String type = Util.shortName(target);
            String name = Util.initLower(type);
            writer.append("  private final %s %s;", type, name).eol();
        }
        writer.eol();
    }

    List<AspectMethod> methods() {
        return this.aspectMethods;
    }
}

