/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Component;
import io.avaje.inject.Factory;
import io.avaje.inject.InjectModule;
import io.avaje.inject.Prototype;
import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.spi.Proxy;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class Processor
extends AbstractProcessor {
    private ProcessingContext context;
    private Elements elementUtils;
    private ScopeInfo defaultScope;
    private AllScopes allScopes;
    private boolean readModuleInfo;

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.context = new ProcessingContext(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.allScopes = new AllScopes(this.context);
        this.defaultScope = this.allScopes.defaultScope();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(InjectModule.class.getCanonicalName());
        annotations.add(Factory.class.getCanonicalName());
        annotations.add(Singleton.class.getCanonicalName());
        annotations.add(Prototype.class.getCanonicalName());
        annotations.add(Scope.class.getCanonicalName());
        annotations.add("io.avaje.inject.test.TestScope");
        annotations.add("io.avaje.http.api.Controller");
        return annotations;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.readModule(roundEnv);
        this.readScopes(roundEnv.getElementsAnnotatedWith(Scope.class));
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(Factory.class), true);
        if (this.defaultScope.includeSingleton()) {
            this.readChangedBeans(roundEnv.getElementsAnnotatedWith(Singleton.class), false);
        }
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(Component.class), false);
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(Prototype.class), false);
        TypeElement typeElement = this.elementUtils.getTypeElement("io.avaje.http.api.Controller");
        if (typeElement != null) {
            this.readChangedBeans(roundEnv.getElementsAnnotatedWith(typeElement), false);
        }
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(Proxy.class), false);
        this.allScopes.readBeans(roundEnv);
        this.defaultScope.write(roundEnv.processingOver());
        this.allScopes.write(roundEnv.processingOver());
        return false;
    }

    private void readScopes(Set<? extends Element> scopes) {
        for (Element element : scopes) {
            if (element.getKind() != ElementKind.ANNOTATION_TYPE || !(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            this.allScopes.addScopeAnnotation(type);
        }
        this.addTestScope();
    }

    private void addTestScope() {
        TypeElement testScopeType = this.elementUtils.getTypeElement("io.avaje.inject.test.TestScope");
        if (testScopeType != null) {
            this.allScopes.addScopeAnnotation(testScopeType);
        }
    }

    private void readChangedBeans(Set<? extends Element> beans, boolean factory) {
        for (Element element : beans) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            ScopeInfo scope = this.findScope(typeElement);
            if (!factory) {
                if (scope != null) continue;
                this.defaultScope.read(typeElement, false);
                continue;
            }
            if (scope != null) {
                scope.read(typeElement, true);
                continue;
            }
            this.defaultScope.read(typeElement, true);
        }
    }

    private ScopeInfo findScope(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ScopeInfo scopeInfo = this.allScopes.get(annotationMirror.getAnnotationType().toString());
            if (scopeInfo == null) continue;
            return scopeInfo;
        }
        return null;
    }

    private void readModule(RoundEnvironment roundEnv) {
        TypeElement moduleType;
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        String factory = this.context.loadMetaInfServices();
        if (factory != null && (moduleType = this.elementUtils.getTypeElement(factory)) != null) {
            this.defaultScope.readModuleMetaData(moduleType);
        }
        this.allScopes.readModules(this.context.loadMetaInfCustom());
        this.readInjectModule(roundEnv);
    }

    private void readInjectModule(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(InjectModule.class)) {
            InjectModule annotation;
            Scope scope = element.getAnnotation(Scope.class);
            if (scope != null || (annotation = element.getAnnotation(InjectModule.class)) == null) continue;
            this.defaultScope.details(annotation.name(), element);
        }
    }
}

