/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.InjectModule;
import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MetaDataOrdering;
import io.avaje.inject.generator.MetaTopPackage;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeUtil;
import io.avaje.inject.generator.SimpleBeanProxyWriter;
import io.avaje.inject.generator.SimpleBeanWriter;
import io.avaje.inject.generator.SimpleModuleWriter;
import io.avaje.inject.generator.Util;
import io.avaje.inject.spi.DependencyMeta;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

class ScopeInfo {
    private final Map<String, MetaData> metaData = new LinkedHashMap<String, MetaData>();
    private final Map<String, String> constructorDependencies = new LinkedHashMap<String, String>();
    private final List<BeanReader> beanReaders = new ArrayList<BeanReader>();
    private final Set<String> readBeans = new HashSet<String>();
    private final ProcessingContext context;
    private final Set<String> requires = new LinkedHashSet<String>();
    private final Set<String> provides = new LinkedHashSet<String>();
    private final Set<String> requiresPackages = new LinkedHashSet<String>();
    private final List<String> requirePkg = new ArrayList<String>();
    private final boolean defaultScope;
    private final TypeElement annotationType;
    private final AllScopes scopes;
    private boolean moduleInitialised;
    private boolean moduleWritten;
    private String name;
    private String modulePackage;
    private String moduleFullName;
    private String moduleShortName;
    private JavaFileObject moduleFile;
    private boolean emptyModule;
    private boolean ignoreSingleton;

    ScopeInfo(ProcessingContext context) {
        this.scopes = null;
        this.context = context;
        this.defaultScope = true;
        this.annotationType = null;
    }

    ScopeInfo(ProcessingContext context, TypeElement type, AllScopes scopes) {
        this.scopes = scopes;
        this.context = context;
        this.defaultScope = false;
        this.annotationType = type;
    }

    public String toString() {
        return "ScopeInfo{name=" + this.name + ", metaData=" + this.metaData + "}";
    }

    boolean includeSingleton() {
        return !this.ignoreSingleton;
    }

    void details(String name, Element contextElement) {
        if (name == null || name.isEmpty()) {
            String simpleName = contextElement.getSimpleName().toString();
            this.name = ScopeUtil.name(simpleName);
        } else {
            this.name = ScopeUtil.name(name);
        }
        this.read(contextElement);
    }

    private void read(Element element) {
        this.ignoreSingleton = ScopeUtil.readIgnoreSingleton(element);
        this.requires(ScopeUtil.readRequires(element));
        this.provides(ScopeUtil.readProvides(element));
        for (String require : ScopeUtil.readRequiresPackages(element)) {
            this.requiresPackages.add(require);
            this.requirePkg.add(Util.packageOf(require) + ".");
        }
    }

    private String initName(String topPackage) {
        if (this.name == null || this.name.isEmpty()) {
            this.name = ScopeUtil.initName(topPackage);
        }
        return this.name;
    }

    void initialiseName(String topPackage) throws IOException {
        boolean bl = this.emptyModule = topPackage == null;
        if (!this.emptyModule) {
            this.modulePackage = topPackage;
            String name = this.initName(this.modulePackage);
            this.moduleShortName = name + "Module";
            this.moduleFullName = this.modulePackage + "." + this.moduleShortName;
            this.moduleFile = this.context.createWriter(this.moduleFullName);
        }
    }

    TypeElement annotationType() {
        return this.annotationType;
    }

    JavaFileObject moduleFile() {
        return this.moduleFile;
    }

    String modulePackage() {
        return this.modulePackage;
    }

    String moduleFullName() {
        return this.moduleFullName;
    }

    String moduleShortName() {
        return this.moduleShortName;
    }

    boolean isDefaultScope() {
        return this.defaultScope;
    }

    String name() {
        return this.name;
    }

    private void provides(List<String> provides) {
        this.provides.addAll(provides);
    }

    private void requires(List<String> contextRequires) {
        this.requires.addAll(contextRequires);
    }

    Set<String> requires() {
        return this.requires;
    }

    void writeBeanHelpers() {
        for (BeanReader beanReader : this.beanReaders) {
            try {
                if (beanReader.isWrittenToFile()) continue;
                SimpleBeanWriter writer = new SimpleBeanWriter(beanReader, this.context);
                writer.write();
                if (beanReader.isGenerateProxy()) {
                    SimpleBeanProxyWriter proxyWriter = new SimpleBeanProxyWriter(beanReader, this.context);
                    proxyWriter.write();
                }
                beanReader.setWrittenToFile();
            }
            catch (FilerException e) {
                this.context.logWarn("FilerException to write $DI class " + beanReader.getBeanType() + " " + e.getMessage(), new Object[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.context.logError(beanReader.getBeanType(), "Failed to write $DI class", new Object[0]);
            }
        }
    }

    private void initialiseModule() {
        if (!this.moduleInitialised) {
            try {
                this.initialiseName(MetaTopPackage.of(this.metaData.values()));
                this.context.addModule(this.moduleFullName);
                this.moduleInitialised = true;
            }
            catch (IOException e) {
                if (this.context.isDuplicateModule(this.moduleFullName)) {
                    String msg = "Attempting to create 2 modules both called " + this.moduleFullName + ". This can occur when a custom scope (named from it's annotation) has a name clash with the default module which can be named from the package. Look to resolve this by either changing the name of the custom scope annotation, or explicitly naming the default scope using @InjectModule(name), or changing the top level package used by the default scope";
                    throw new IllegalStateException(msg);
                }
                this.context.logError("Failed to create module filer " + e.getMessage(), new Object[0]);
            }
        }
    }

    void writeModule() {
        if (this.moduleWritten) {
            this.context.logError("already written module " + this.name, new Object[0]);
            return;
        }
        Collection<MetaData> meta = this.metaData.values();
        if (this.emptyModule) {
            if (meta.size() > 0) {
                String msg = meta + " is being ignored by avaje-inject as there is no 'default' module. This is expected when " + meta + " is a @Singleton being generated by an annotation processor but there is no 'default' module (only custom modules are being used).";
                this.context.logWarn(msg, new Object[0]);
            }
            return;
        }
        MetaDataOrdering ordering = new MetaDataOrdering(meta, this.context, this);
        int remaining = ordering.processQueue();
        if (remaining > 0) {
            ordering.logWarnings();
        }
        try {
            SimpleModuleWriter factoryWriter = new SimpleModuleWriter(ordering, this.context, this);
            factoryWriter.write(this.type());
            this.moduleWritten = true;
        }
        catch (FilerException e) {
            this.context.logWarn("FilerException trying to write factory " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this.context.logError("Failed to write factory " + e.getMessage(), new Object[0]);
        }
    }

    Type type() {
        return this.annotationType == null ? Type.DEFAULT : ("io.avaje.inject.test.TestScope".equals(this.annotationType.getQualifiedName().toString()) ? Type.TEST : Type.CUSTOM);
    }

    void mergeMetaData() {
        for (BeanReader beanReader : this.beanReaders) {
            if (beanReader.isRequestScopedController()) continue;
            MetaData metaData = this.metaData.get(beanReader.getMetaKey());
            if (metaData == null) {
                this.addMeta(beanReader);
                continue;
            }
            this.updateMeta(metaData, beanReader);
        }
    }

    private void addMeta(BeanReader beanReader) {
        MetaData meta = beanReader.createMeta();
        this.metaData.put(meta.getKey(), meta);
        for (MetaData methodMeta : beanReader.createFactoryMethodMeta()) {
            this.metaData.put(methodMeta.getKey(), methodMeta);
        }
    }

    private void updateMeta(MetaData metaData, BeanReader beanReader) {
        metaData.update(beanReader);
    }

    private void readBeanMeta(TypeElement typeElement, boolean factory) {
        if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            this.context.logDebug("skipping annotation type " + typeElement, new Object[0]);
            return;
        }
        this.beanReaders.add(new BeanReader(typeElement, this.context, factory).read());
    }

    void readBuildMethodDependencyMeta(Element element) {
        Name simpleName = element.getSimpleName();
        if (simpleName.toString().startsWith("build_")) {
            DependencyMeta meta = element.getAnnotation(DependencyMeta.class);
            if (meta == null) {
                this.context.logError("Missing @DependencyMeta on method " + simpleName, new Object[0]);
            } else {
                MetaData metaData = new MetaData(meta);
                this.metaData.put(metaData.getKey(), metaData);
            }
        }
    }

    void read(TypeElement element, boolean factory) {
        if (this.readBeans.add(element.toString())) {
            this.readBeanMeta(element, factory);
        } else {
            this.context.logDebug("skipping already processed bean " + element, new Object[0]);
        }
    }

    void write(boolean processingOver) {
        this.mergeMetaData();
        this.writeBeanHelpers();
        this.initialiseModule();
        if (processingOver && !this.metaData.isEmpty()) {
            this.writeModule();
        }
    }

    void buildAtInjectModule(Append writer) {
        writer.append("@Generated(\"io.avaje.inject.generator\")").eol();
        writer.append("@InjectModule(");
        boolean leadingComma = false;
        if (!this.provides.isEmpty()) {
            this.attributeClasses(false, writer, "provides", this.provides);
            leadingComma = true;
        }
        if (!this.requires.isEmpty()) {
            this.attributeClasses(leadingComma, writer, "requires", this.requires);
            leadingComma = true;
        }
        if (!this.requiresPackages.isEmpty()) {
            this.attributeClasses(leadingComma, writer, "requiresPackages", this.requiresPackages);
            leadingComma = true;
        }
        if (this.annotationType != null) {
            if (leadingComma) {
                writer.append(", ");
            }
            writer.append("customScopeType=\"%s\"", this.annotationType.getQualifiedName().toString());
        }
        writer.append(")").eol();
    }

    private void attributeClasses(boolean leadingComma, Append writer, String prefix, Set<String> classNames) {
        if (leadingComma) {
            writer.append(", ");
        }
        writer.append("%s={", prefix);
        int c = 0;
        for (String value : classNames) {
            if (c++ > 0) {
                writer.append(",");
            }
            writer.append(value).append(".class");
        }
        writer.append("}");
    }

    private void buildClassArray(Append writer, Set<String> values) {
        writer.append("new Class<?>[]");
        writer.append("{");
        if (!values.isEmpty()) {
            int c = 0;
            for (String value : values) {
                if (c++ > 0) {
                    writer.append(",");
                }
                writer.append(value).append(".class");
            }
        }
        writer.append("}");
    }

    void buildFields(Append writer) {
        writer.append("  private final Class<?>[] provides = ");
        this.buildClassArray(writer, this.provides);
        writer.append(";").eol();
        writer.append("  private final Class<?>[] requires = ");
        this.buildClassArray(writer, this.requires);
        writer.append(";").eol();
        writer.append("  private final Class<?>[] requiresPackages = ");
        this.buildClassArray(writer, this.requiresPackages);
        writer.append(";").eol();
        writer.append("  private Builder builder;").eol().eol();
    }

    void readModuleMetaData(TypeElement moduleType) {
        InjectModule module = moduleType.getAnnotation(InjectModule.class);
        this.details(module.name(), moduleType);
        this.readFactoryMetaData(moduleType);
    }

    private void readFactoryMetaData(TypeElement moduleType) {
        List<? extends Element> elements = moduleType.getEnclosedElements();
        if (elements != null) {
            for (Element element : elements) {
                if (ElementKind.METHOD != element.getKind()) continue;
                this.readBuildMethodDependencyMeta(element);
            }
        }
    }

    boolean providedByOtherModule(String dependency) {
        if (this.defaultScope) {
            return false;
        }
        if (this.scopes.providedByDefaultModule(dependency)) {
            return true;
        }
        return this.providesDependencyRecursive(dependency);
    }

    private boolean providesDependencyRecursive(String dependency) {
        if (this.providesDependencyLocally(dependency)) {
            return true;
        }
        for (String require : this.requires) {
            ScopeInfo requiredScope = this.scopes.get(require);
            if (requiredScope == null || !requiredScope.providesDependencyRecursive(dependency)) continue;
            return true;
        }
        return false;
    }

    boolean providesDependencyLocally(String dependency) {
        if (this.requires.contains(dependency)) {
            return true;
        }
        for (MetaData meta : this.metaData.values()) {
            if (dependency.equals(meta.getType())) {
                return true;
            }
            List<String> provides = meta.getProvides();
            if (provides == null || provides.isEmpty()) continue;
            for (String provide : provides) {
                if (!dependency.equals(provide)) continue;
                return true;
            }
        }
        return false;
    }

    boolean providedByPackage(String dependency) {
        for (String pkg : this.requirePkg) {
            if (!dependency.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    boolean providedByOther(Dependency dependency) {
        return dependency.isSoftDependency() || this.providedByPackage(dependency.getName()) || this.providedByOtherModule(dependency.getName());
    }

    Set<String> initModuleDependencies(Set<String> importTypes) {
        if (this.defaultScope || this.requires.isEmpty()) {
            return importTypes;
        }
        for (String require : this.requires) {
            ScopeInfo otherScope = this.scopes.get(require);
            if (otherScope != null) continue;
            importTypes.add(require);
            String type = Util.shortName(require);
            String var = Util.initLower(type);
            this.constructorDependencies.put(type, var);
        }
        return importTypes;
    }

    boolean addModuleConstructor() {
        return !this.constructorDependencies.isEmpty();
    }

    Map<String, String> constructorDependencies() {
        return this.constructorDependencies;
    }

    boolean addWithBeans() {
        return !this.constructorDependencies.isEmpty();
    }

    static enum Type {
        DEFAULT("Module"),
        CUSTOM("Module.Custom"),
        TEST("io.avaje.inject.test.TestModule");

        final String type;

        private Type(String type) {
            this.type = type;
        }

        String type() {
            return this.type;
        }
    }
}

