/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MetaDataOrdering;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;

class SimpleModuleWriter {
    private static final String CODE_COMMENT_FACTORY = "/**\n * Generated source - avaje inject module for %s.\n * \n * With Java module system this generated class should be explicitly\n * registered in module-info via a <code>provides</code> clause like:\n * \n * <pre>{@code\n * \n *   module example {\n *     requires io.avaje.inject;\n *     \n *     provides io.avaje.inject.spi.Module with %s.%s;\n *     \n *   }\n * \n * }</pre>\n */";
    private static final String CODE_COMMENT_CREATE_CONTEXT = "  /**\n   * Create the beans.\n   * <p>\n   * Creates all the beans in order based on constructor dependencies.\n   * The beans are registered into the builder along with callbacks for\n   * field injection, method injection and lifecycle support.\n   */";
    private final ProcessingContext context;
    private final String modulePackage;
    private final String shortName;
    private final String fullName;
    private final ScopeInfo scopeInfo;
    private final MetaDataOrdering ordering;
    private Append writer;

    SimpleModuleWriter(MetaDataOrdering ordering, ProcessingContext context, ScopeInfo scopeInfo) {
        this.ordering = ordering;
        this.context = context;
        this.scopeInfo = scopeInfo;
        this.modulePackage = scopeInfo.modulePackage();
        this.shortName = scopeInfo.moduleShortName();
        this.fullName = scopeInfo.moduleFullName();
    }

    void write(ScopeInfo.Type scopeType) throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeStartClass();
        this.writeClassesMethod();
        this.writeBuildMethod();
        this.writeBuildMethods();
        this.writeEndClass();
        this.writer.close();
        if (scopeType != ScopeInfo.Type.CUSTOM) {
            this.writeServicesFile(scopeType);
        }
    }

    private void writeServicesFile(ScopeInfo.Type scopeType) {
        try {
            FileObject jfo = this.context.createMetaInfWriter(scopeType);
            if (jfo != null) {
                Writer writer = jfo.openWriter();
                writer.write(this.fullName);
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.context.logError("Failed to write services file " + e.getMessage(), new Object[0]);
        }
    }

    private void writeClassesMethod() {
        Set<String> allClasses = this.distinctPublicClasses();
        this.writer.append("  @Override").eol();
        this.writer.append("  public Class<?>[] classes() {").eol();
        this.writer.append("    return new Class<?>[]{").eol();
        for (String rawType : allClasses) {
            this.writer.append("      %s.class,", rawType).eol();
        }
        this.writer.append("    };").eol();
        this.writer.append("  }").eol().eol();
    }

    private Set<String> distinctPublicClasses() {
        LinkedHashSet<String> publicClasses = new LinkedHashSet<String>();
        for (MetaData metaData : this.ordering.ordered()) {
            String type;
            TypeElement element;
            String rawType = metaData.getType();
            if ("void".equals(rawType) || (element = this.context.element(type = GenericType.parse(rawType).topType())) == null || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            publicClasses.add(type);
        }
        return publicClasses;
    }

    private void writeBuildMethod() {
        this.writer.append(CODE_COMMENT_CREATE_CONTEXT).eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public void build(Builder builder) {").eol();
        if (this.scopeInfo.addWithBeans()) {
            this.writeWithBeans();
        }
        this.writer.append("    this.builder = builder;").eol();
        this.writer.append("    // create beans in order based on constructor dependencies").eol();
        this.writer.append("    // i.e. \"provides\" followed by \"dependsOn\"").eol();
        for (MetaData metaData : this.ordering.ordered()) {
            this.writer.append("    build_%s();", metaData.getBuildName()).eol();
        }
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writeBuildMethods() {
        for (MetaData metaData : this.ordering.ordered()) {
            this.writer.append(metaData.buildMethod(this.ordering)).eol();
        }
    }

    private void writePackage() {
        this.writer.append("package %s;", this.modulePackage).eol().eol();
        for (String type : this.factoryImportTypes()) {
            this.writer.append("import %s;", type).eol();
        }
        for (String type : this.scopeInfo.initModuleDependencies(this.ordering.importTypes())) {
            if (!Util.validImportType(type)) continue;
            this.writer.append("import %s;", type).eol();
        }
        this.writer.eol();
    }

    private Set<String> factoryImportTypes() {
        TreeSet<String> importTypes = new TreeSet<String>();
        importTypes.add("io.avaje.inject.spi.Generated");
        importTypes.add("io.avaje.inject.BeanScope");
        importTypes.add("io.avaje.inject.InjectModule");
        importTypes.add("io.avaje.inject.spi.DependencyMeta");
        importTypes.add("io.avaje.inject.spi.Module");
        importTypes.add("io.avaje.inject.spi.Builder");
        return importTypes;
    }

    private void writeStartClass() {
        this.writer.append(CODE_COMMENT_FACTORY, this.scopeInfo.name(), this.modulePackage, this.shortName).eol();
        this.scopeInfo.buildAtInjectModule(this.writer);
        String interfaceType = this.scopeInfo.type().type();
        this.writer.append("public class %s implements %s {", this.shortName, interfaceType).eol().eol();
        this.scopeInfo.buildFields(this.writer);
        if (this.scopeInfo.addModuleConstructor()) {
            this.writeConstructor();
        }
        this.writer.append("  @Override").eol();
        this.writer.append("  public Class<?>[] provides() {").eol();
        this.writer.append("    return provides;").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public Class<?>[] requires() {").eol();
        this.writer.append("    return requires;").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @Override").eol();
        this.writer.append("  public Class<?>[] requiresPackages() {").eol();
        this.writer.append("    return requiresPackages;").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeWithBeans() {
        this.writer.append("    // register external dependencies").eol();
        Map<String, String> dependencies = this.scopeInfo.constructorDependencies();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            this.writer.append("    builder.withBean(%s.class, %s);", entry.getKey(), entry.getValue()).eol();
        }
    }

    private void writeConstructor() {
        Map<String, String> dependencies = this.scopeInfo.constructorDependencies();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            this.writer.append("  private %s %s;", entry.getKey(), entry.getValue()).eol();
        }
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Create providing the external dependencies.").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public %s(", this.shortName);
        boolean comma = false;
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            if (!comma) {
                comma = true;
            } else {
                this.writer.append(", ");
            }
            this.writer.append(entry.getKey()).append(" ").append(entry.getValue());
        }
        this.writer.append(") {", this.shortName).eol();
        for (Map.Entry<String, String> entry : dependencies.entrySet()) {
            this.writer.append("    this.%s = %s;", entry.getValue(), entry.getValue()).eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeEndClass() {
        this.writer.append("}").eol();
    }

    private Writer createFileWriter() throws IOException {
        return this.scopeInfo.moduleFile().openWriter();
    }
}

