/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.Bean;
import io.avaje.inject.Prototype;
import io.avaje.inject.generator.AnnotationUtil;
import io.avaje.inject.generator.AspectAnnotationReader;
import io.avaje.inject.generator.AspectMethod;
import io.avaje.inject.generator.AspectPair;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.Util;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

class TypeExtendsInjection {
    private MethodReader injectConstructor;
    private final List<MethodReader> otherConstructors = new ArrayList<MethodReader>();
    private final List<MethodReader> factoryMethods = new ArrayList<MethodReader>();
    private final List<FieldReader> injectFields = new ArrayList<FieldReader>();
    private final Map<String, MethodReader> injectMethods = new LinkedHashMap<String, MethodReader>();
    private final Set<String> notInjectMethods = new HashSet<String>();
    private final List<AspectMethod> aspectMethods = new ArrayList<AspectMethod>();
    private final Map<String, Integer> nameIndex = new HashMap<String, Integer>();
    private final TypeElement baseType;
    private final ProcessingContext context;
    private final boolean factory;
    private final List<AspectPair> typeAspects;
    private Element postConstructMethod;
    private Element preDestroyMethod;

    TypeExtendsInjection(TypeElement baseType, ProcessingContext context, boolean factory) {
        this.baseType = baseType;
        this.context = context;
        this.factory = factory;
        AspectAnnotationReader reader = new AspectAnnotationReader(context, baseType, baseType);
        this.typeAspects = reader.read();
    }

    void read(TypeElement type) {
        for (Element element : type.getEnclosedElements()) {
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    this.readConstructor(element, type);
                    break;
                }
                case FIELD: {
                    this.readField(element);
                    break;
                }
                case METHOD: {
                    this.readMethod(element, type);
                }
            }
        }
    }

    private void readField(Element element) {
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectFields.add(new FieldReader(element));
        }
    }

    private void readConstructor(Element element, TypeElement type) {
        if (type != this.baseType) {
            return;
        }
        ExecutableElement ex = (ExecutableElement)element;
        MethodReader methodReader = new MethodReader(this.context, ex, this.baseType).read();
        Inject inject = element.getAnnotation(Inject.class);
        if (inject != null) {
            this.injectConstructor = methodReader;
        } else if (methodReader.isNotPrivate()) {
            this.otherConstructors.add(methodReader);
        }
    }

    private void readMethod(Element element, TypeElement type) {
        Bean bean;
        boolean checkAspect = true;
        ExecutableElement methodElement = (ExecutableElement)element;
        if (this.factory && (bean = element.getAnnotation(Bean.class)) != null) {
            this.addFactoryMethod(methodElement, bean);
            checkAspect = false;
        }
        Inject inject = element.getAnnotation(Inject.class);
        String methodKey = methodElement.getSimpleName().toString();
        if (inject != null && !this.notInjectMethods.contains(methodKey)) {
            MethodReader methodReader;
            if (!this.injectMethods.containsKey(methodKey) && (methodReader = new MethodReader(this.context, methodElement, type).read()).isNotPrivate()) {
                this.injectMethods.put(methodKey, methodReader);
                checkAspect = false;
            }
        } else {
            this.notInjectMethods.add(methodKey);
        }
        if (AnnotationUtil.hasAnnotationWithName(element, "PostConstruct")) {
            this.postConstructMethod = element;
            checkAspect = false;
        }
        if (AnnotationUtil.hasAnnotationWithName(element, "PreDestroy")) {
            this.preDestroyMethod = element;
            checkAspect = false;
        }
        if (checkAspect) {
            this.checkForAspect(methodElement);
        }
    }

    private int methodNameIndex(String name) {
        Integer counter = this.nameIndex.get(name);
        if (counter == null) {
            this.nameIndex.put(name, 1);
            return 0;
        }
        this.nameIndex.put(name, counter + 1);
        return counter;
    }

    private void checkForAspect(ExecutableElement methodElement) {
        Set<Modifier> modifiers = methodElement.getModifiers();
        if (modifiers.contains((Object)Modifier.PRIVATE) || modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.ABSTRACT)) {
            return;
        }
        int nameIndex = this.methodNameIndex(methodElement.getSimpleName().toString());
        List<AspectPair> aspectPairs = new AspectAnnotationReader(this.context, this.baseType, methodElement).read();
        aspectPairs.addAll(this.typeAspects);
        if (!aspectPairs.isEmpty()) {
            this.aspectMethods.add(new AspectMethod(nameIndex, aspectPairs, methodElement));
        }
    }

    private void addFactoryMethod(ExecutableElement methodElement, Bean bean) {
        String qualifierName = Util.getNamed(methodElement);
        boolean prototype = methodElement.getAnnotation(Prototype.class) != null;
        this.factoryMethods.add(new MethodReader(this.context, methodElement, this.baseType, bean, qualifierName, prototype).read());
    }

    BeanAspects hasAspects() {
        return this.aspectMethods.isEmpty() ? BeanAspects.EMPTY : new BeanAspects(this.aspectMethods);
    }

    void removeFromProvides(List<String> provides) {
        MethodReader constructor = this.getConstructor();
        if (constructor != null) {
            constructor.removeFromProvides(provides);
        }
        for (FieldReader injectField : this.injectFields) {
            injectField.removeFromProvides(provides);
        }
        for (MethodReader injectMethod : this.injectMethods.values()) {
            injectMethod.removeFromProvides(provides);
        }
    }

    List<FieldReader> getInjectFields() {
        ArrayList<FieldReader> list = new ArrayList<FieldReader>(this.injectFields);
        Collections.reverse(list);
        return list;
    }

    List<MethodReader> getInjectMethods() {
        ArrayList<MethodReader> list = new ArrayList<MethodReader>(this.injectMethods.values());
        Collections.reverse(list);
        return list;
    }

    List<MethodReader> getFactoryMethods() {
        return this.factoryMethods;
    }

    Element getPostConstructMethod() {
        return this.postConstructMethod;
    }

    Element getPreDestroyMethod() {
        return this.preDestroyMethod;
    }

    MethodReader getConstructor() {
        if (this.injectConstructor != null) {
            return this.injectConstructor;
        }
        if (this.otherConstructors.size() == 1) {
            return this.otherConstructors.get(0);
        }
        ArrayList<MethodReader> allPublic = new ArrayList<MethodReader>();
        for (MethodReader ctor : this.otherConstructors) {
            if (!ctor.isPublic()) continue;
            allPublic.add(ctor);
        }
        if (allPublic.size() == 1) {
            return (MethodReader)allPublic.get(0);
        }
        return null;
    }
}

