/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeExtendsInjection;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

class TypeExtendsReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private final GenericType baseGenericType;
    private final TypeElement baseType;
    private final ProcessingContext context;
    private final TypeExtendsInjection extendsInjection;
    private final List<String> extendsTypes = new ArrayList<String>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private final List<String> providesTypes = new ArrayList<String>();
    private final String beanSimpleName;
    private final String baseTypeRaw;
    private boolean closeable;
    private String qualifierName;

    TypeExtendsReader(GenericType baseGenericType, TypeElement baseType, ProcessingContext context, boolean factory) {
        this.baseGenericType = baseGenericType;
        this.baseType = baseType;
        this.context = context;
        this.extendsInjection = new TypeExtendsInjection(baseType, context, factory);
        this.beanSimpleName = baseType.getSimpleName().toString();
        this.baseTypeRaw = Util.unwrapProvider(baseGenericType.toString());
    }

    GenericType getBaseType() {
        return this.baseGenericType;
    }

    String getQualifierName() {
        return this.qualifierName;
    }

    BeanAspects hasAspects() {
        return this.extendsInjection.hasAspects();
    }

    List<FieldReader> getInjectFields() {
        return this.extendsInjection.getInjectFields();
    }

    List<MethodReader> getInjectMethods() {
        return this.extendsInjection.getInjectMethods();
    }

    List<MethodReader> getFactoryMethods() {
        return this.extendsInjection.getFactoryMethods();
    }

    Element getPostConstructMethod() {
        return this.extendsInjection.getPostConstructMethod();
    }

    Element getPreDestroyMethod() {
        return this.extendsInjection.getPreDestroyMethod();
    }

    MethodReader getConstructor() {
        return this.extendsInjection.getConstructor();
    }

    List<String> getProvides() {
        return this.providesTypes;
    }

    boolean isCloseable() {
        return this.closeable;
    }

    void process(boolean forBean) {
        this.extendsTypes.add(this.baseTypeRaw);
        if (forBean) {
            this.extendsInjection.read(this.baseType);
        }
        this.readInterfaces(this.baseType);
        TypeElement superElement = this.superOf(this.baseType);
        if (superElement != null) {
            String superName;
            String baseName;
            if (this.qualifierName == null && (baseName = this.baseType.getSimpleName().toString()).endsWith(superName = superElement.getSimpleName().toString())) {
                this.qualifierName = baseName.substring(0, baseName.length() - superName.length()).toLowerCase();
            }
            this.addSuperType(superElement);
        }
        this.providesTypes.addAll(this.extendsTypes);
        this.providesTypes.addAll(this.interfaceTypes);
        this.providesTypes.remove(this.baseTypeRaw);
        this.extendsInjection.removeFromProvides(this.providesTypes);
    }

    private void addSuperType(TypeElement element) {
        this.readInterfaces(element);
        String fullName = element.getQualifiedName().toString();
        if (!fullName.equals(JAVA_LANG_OBJECT)) {
            String type = Util.unwrapProvider(fullName);
            if (this.isPublic(element)) {
                this.extendsTypes.add(type);
                this.extendsInjection.read(element);
            }
            this.addSuperType(this.superOf(element));
        }
    }

    private TypeElement superOf(TypeElement element) {
        return (TypeElement)this.context.asElement(element.getSuperclass());
    }

    private void readInterfaces(TypeElement type) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            if (!this.isPublic(this.context.asElement(typeMirror))) continue;
            this.readInterfacesOf(typeMirror);
        }
    }

    private void readInterfacesOf(TypeMirror anInterface) {
        String rawType = Util.unwrapProvider(anInterface.toString());
        if (JAVA_LANG_OBJECT.equals(rawType)) {
            return;
        }
        if (rawType.indexOf(46) == -1) {
            this.context.logWarn("skip when no package on interface " + rawType, new Object[0]);
        } else if ("java.lang.AutoCloseable".equals(rawType) || "java.io.Closeable".equals(rawType)) {
            this.closeable = true;
        } else {
            String mainType;
            String string;
            if (this.qualifierName == null && this.beanSimpleName.endsWith(string = Util.shortName(mainType = GenericType.removeParameter(rawType)))) {
                this.qualifierName = this.beanSimpleName.substring(0, this.beanSimpleName.length() - string.length()).toLowerCase();
            }
            this.interfaceTypes.add(rawType);
            for (TypeMirror typeMirror : this.context.types().directSupertypes(anInterface)) {
                this.readInterfacesOf(typeMirror);
            }
        }
    }

    private boolean isPublic(Element element) {
        return element != null && element.getModifiers().contains((Object)Modifier.PUBLIC);
    }
}

