/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.TypeAnnotationReader;
import io.avaje.inject.generator.TypeAppender;
import io.avaje.inject.generator.TypeExtendsReader;
import jakarta.inject.Named;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

class TypeReader {
    private final boolean forBean;
    private final TypeElement beanType;
    private final Set<String> importTypes;
    private final TypeExtendsReader extendsReader;
    private final TypeAnnotationReader annotationReader;
    private Set<GenericType> genericTypes;
    private String typesRegister;

    TypeReader(GenericType genericType, TypeElement beanType, ProcessingContext context, Set<String> importTypes, boolean factory) {
        this(genericType, true, beanType, context, importTypes, factory);
    }

    TypeReader(GenericType genericType, TypeElement returnElement, ProcessingContext context) {
        this(genericType, false, returnElement, context, new LinkedHashSet<String>(), false);
    }

    private TypeReader(GenericType genericType, boolean forBean, TypeElement beanType, ProcessingContext context, Set<String> importTypes, boolean factory) {
        this.forBean = forBean;
        this.beanType = beanType;
        this.importTypes = importTypes;
        this.extendsReader = new TypeExtendsReader(genericType, beanType, context, factory);
        this.annotationReader = new TypeAnnotationReader(beanType, context);
    }

    String getTypesRegister() {
        return this.typesRegister;
    }

    List<String> getProvides() {
        return this.extendsReader.getProvides();
    }

    boolean isClosable() {
        return this.extendsReader.isCloseable();
    }

    void addImports(Set<String> importTypes) {
        importTypes.addAll(this.importTypes);
    }

    BeanAspects hasAspects() {
        return this.extendsReader.hasAspects();
    }

    List<FieldReader> getInjectFields() {
        return this.extendsReader.getInjectFields();
    }

    List<MethodReader> getInjectMethods() {
        return this.extendsReader.getInjectMethods();
    }

    List<MethodReader> getFactoryMethods() {
        return this.extendsReader.getFactoryMethods();
    }

    Element getPostConstructMethod() {
        return this.extendsReader.getPostConstructMethod();
    }

    Element getPreDestroyMethod() {
        return this.extendsReader.getPreDestroyMethod();
    }

    MethodReader getConstructor() {
        return this.extendsReader.getConstructor();
    }

    Set<GenericType> getGenericTypes() {
        return this.genericTypes;
    }

    void process() {
        this.extendsReader.process(this.forBean);
        if (this.forBean) {
            this.annotationReader.process();
        }
        this.initRegistrationTypes();
    }

    String getName() {
        Named named = this.beanType.getAnnotation(Named.class);
        if (named != null) {
            return named.value().toLowerCase();
        }
        if (this.annotationReader.hasQualifierName()) {
            return this.annotationReader.getQualifierName();
        }
        return this.extendsReader.getQualifierName();
    }

    private void initRegistrationTypes() {
        TypeAppender appender = new TypeAppender(this.importTypes);
        appender.add(this.extendsReader.getBaseType());
        appender.add(this.extendsReader.getProvides());
        if (this.forBean) {
            appender.add(this.annotationReader.getAnnotationTypes());
        }
        this.genericTypes = appender.genericTypes();
        this.typesRegister = appender.asString();
    }

    void extraImports(Set<String> importTypes) {
        if (!this.genericTypes.isEmpty()) {
            importTypes.add("java.lang.reflect.Type");
            importTypes.add("io.avaje.inject.spi.GenericType");
            importTypes.add("jakarta.inject.Provider");
            for (GenericType type : this.genericTypes) {
                type.addImports(importTypes);
            }
        }
    }
}

