/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.UtilType;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

class Util {
    static final String PROVIDER_PREFIX = "jakarta.inject.Provider<";
    private static final String OPTIONAL_PREFIX = "java.util.Optional<";
    private static final String NULLABLE = "Nullable";
    private static final int PROVIDER_LENGTH = "jakarta.inject.Provider<".length();

    Util() {
    }

    static boolean isVoid(String type) {
        return "void".equalsIgnoreCase(type);
    }

    static boolean validImportType(String type) {
        return type.indexOf(46) > 0;
    }

    static String classOfMethod(String method) {
        return Util.packageOf(method);
    }

    static String shortMethod(String method) {
        int p = (method = Util.trimGenerics(method)).lastIndexOf(46);
        if (p > -1 && (p = method.lastIndexOf(46, p - 1)) > -1) {
            return method.substring(p + 1);
        }
        return method;
    }

    static String trimGenerics(String type) {
        int i = type.indexOf(60);
        if (i == -1) {
            return type;
        }
        return type.substring(0, i);
    }

    static String nestedPackageOf(String cls) {
        int pos = cls.lastIndexOf(46);
        if (pos < 0) {
            return "";
        }
        return (pos = cls.lastIndexOf(46, pos - 1)) == -1 ? "" : cls.substring(0, pos);
    }

    static String packageOf(String cls) {
        int pos = cls.lastIndexOf(46);
        return pos == -1 ? "" : cls.substring(0, pos);
    }

    static String unwrapProvider(String maybeProvider) {
        if (Util.isProvider(maybeProvider)) {
            return Util.extractProviderType(maybeProvider);
        }
        return maybeProvider;
    }

    static String initLower(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean upper = true;
        for (char ch : name.toCharArray()) {
            if (upper && Character.isUpperCase(ch)) {
                sb.append(Character.toLowerCase(ch));
                continue;
            }
            upper = false;
            sb.append(ch);
        }
        return sb.toString();
    }

    static String nestedShortName(String fullType) {
        int pos = fullType.lastIndexOf(46);
        if (pos < 0) {
            return fullType;
        }
        return (pos = fullType.lastIndexOf(46, pos - 1)) < 0 ? fullType : fullType.substring(pos + 1);
    }

    static String shortName(String fullType) {
        int p = fullType.lastIndexOf(46);
        if (p == -1) {
            return fullType;
        }
        return fullType.substring(p + 1);
    }

    static String trimmedName(GenericType type) {
        return Util.shortName(type.topType()).toLowerCase();
    }

    static boolean isOptional(String rawType) {
        return rawType.startsWith(OPTIONAL_PREFIX);
    }

    static String extractOptionalType(String rawType) {
        return rawType.substring(19, rawType.length() - 1);
    }

    static String extractList(String rawType) {
        String listType = rawType.substring(15, rawType.length() - 1);
        if (listType.startsWith("? extends")) {
            return listType.substring(10);
        }
        return listType;
    }

    static String extractSet(String rawType) {
        String setType = rawType.substring(14, rawType.length() - 1);
        if (setType.startsWith("? extends")) {
            return setType.substring(10);
        }
        return setType;
    }

    static String extractMap(String rawType) {
        String valType = rawType.substring(31, rawType.length() - 1);
        if (valType.startsWith("? extends")) {
            return valType.substring(10);
        }
        return valType;
    }

    static UtilType determineType(TypeMirror rawType) {
        return UtilType.of(rawType.toString());
    }

    static boolean isProvider(String rawType) {
        return rawType.startsWith(PROVIDER_PREFIX);
    }

    private static String extractProviderType(String rawType) {
        return rawType.substring(PROVIDER_LENGTH, rawType.length() - 1);
    }

    static String commonParent(String currentTop, String aPackage) {
        int next;
        if (aPackage == null) {
            return currentTop;
        }
        if (currentTop == null) {
            return aPackage;
        }
        if (aPackage.startsWith(currentTop)) {
            return currentTop;
        }
        do {
            if ((next = currentTop.lastIndexOf(46)) <= -1 || !aPackage.startsWith(currentTop = currentTop.substring(0, next))) continue;
            return currentTop;
        } while (next > -1);
        return currentTop;
    }

    public static String getNamed(Element p) {
        Named named = p.getAnnotation(Named.class);
        if (named != null) {
            return named.value().toLowerCase();
        }
        for (AnnotationMirror annotationMirror : p.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            Qualifier qualifier = annotationType.asElement().getAnnotation(Qualifier.class);
            if (qualifier == null) continue;
            return Util.shortName(annotationType.toString()).toLowerCase();
        }
        return null;
    }

    public static boolean isNullable(Element p) {
        for (AnnotationMirror annotationMirror : p.getAnnotationMirrors()) {
            if (!NULLABLE.equals(Util.shortName(annotationMirror.getAnnotationType().toString()))) continue;
            return true;
        }
        return false;
    }

    public static String addForInterface(String interfaceType) {
        if (interfaceType.contains("<")) {
            return null;
        }
        return Util.shortName(interfaceType);
    }

    public static String trimMethod(String method) {
        return Util.shortMethod(method).replace('.', '_').replace("$DI", "");
    }
}

