/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Util;

class UtilType {
    private final Type type;
    private final String rawType;

    private UtilType(Type type, String rawType) {
        this.type = type;
        this.rawType = rawType;
    }

    static UtilType of(String rawType) {
        if (rawType.startsWith("java.util.List<")) {
            return new UtilType(Type.LIST, rawType);
        }
        if (rawType.startsWith("java.util.Set<")) {
            return new UtilType(Type.SET, rawType);
        }
        if (rawType.startsWith("java.util.Map<java.lang.String,")) {
            return new UtilType(Type.MAP, rawType);
        }
        if (rawType.startsWith("java.util.Optional<")) {
            return new UtilType(Type.OPTIONAL, rawType);
        }
        if (Util.isProvider(rawType)) {
            return new UtilType(Type.PROVIDER, rawType);
        }
        return new UtilType(Type.OTHER, rawType);
    }

    boolean allowsNamedQualifier() {
        return this.type == Type.OPTIONAL || this.type == Type.OTHER;
    }

    boolean isCollection() {
        return this.type == Type.LIST || this.type == Type.SET;
    }

    String full() {
        return this.rawType;
    }

    String rawType() {
        switch (this.type) {
            case SET: {
                return Util.extractSet(this.rawType);
            }
            case LIST: {
                return Util.extractList(this.rawType);
            }
            case MAP: {
                return Util.extractMap(this.rawType);
            }
            case OPTIONAL: {
                return Util.extractOptionalType(this.rawType);
            }
        }
        return this.rawType;
    }

    String getMethod(boolean nullable) {
        switch (this.type) {
            case SET: {
                return "set(";
            }
            case LIST: {
                return "list(";
            }
            case MAP: {
                return "map(";
            }
            case OPTIONAL: {
                return "getOptional(";
            }
            case PROVIDER: {
                return "getProvider(";
            }
        }
        return nullable ? "getNullable(" : "get(";
    }

    private static enum Type {
        LIST,
        SET,
        MAP,
        OPTIONAL,
        PROVIDER,
        OTHER;

    }
}

