/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.GenericTypeParser;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class GenericType {
    private final String raw;
    private String mainType;
    private final List<GenericType> params = new ArrayList<GenericType>();

    static String trimWildcard(String rawType) {
        if (rawType.endsWith("<?>")) {
            return rawType.substring(0, rawType.length() - 3);
        }
        return GenericType.trimGenericParams(rawType);
    }

    static String trimGenericParams(String rawType) {
        int start = rawType.indexOf(60);
        if (start > 0 && rawType.indexOf(46, start) == -1 && rawType.lastIndexOf(62) > -1) {
            return rawType.substring(0, start);
        }
        return rawType;
    }

    GenericType(String raw) {
        this.raw = raw;
    }

    GenericType() {
        this.raw = null;
    }

    static boolean isGeneric(String raw) {
        return raw.contains("<");
    }

    static GenericType parse(String raw) {
        raw = Util.trimAnnotations(raw);
        if ((raw = GenericType.trimWildcard(raw)).indexOf(60) == -1) {
            return new GenericType(raw);
        }
        return new GenericTypeParser(raw).parse();
    }

    static String removeParameter(String raw) {
        GenericType type = GenericType.parse(raw);
        return type.topType();
    }

    public String toString() {
        return this.raw != null ? this.raw : this.mainType + "<" + this.params + ">";
    }

    boolean isGenericType() {
        return !this.params.isEmpty();
    }

    boolean isProviderType() {
        return this.raw.startsWith("jakarta.inject.Provider<");
    }

    void addImports(ImportTypeMap importTypes) {
        String type = this.trimExtends();
        if (GenericType.includeInImports(type)) {
            importTypes.add(type);
        }
        for (GenericType param : this.params) {
            param.addImports(importTypes);
        }
    }

    private static boolean includeInImports(String type) {
        return type != null && !type.startsWith("java.lang.") && type.contains(".");
    }

    void writeShort(Append writer) {
        String main = Util.shortName(this.trimExtends());
        writer.append(main);
        int paramCount = this.params.size();
        if (paramCount > 0) {
            writer.append("<");
            for (int i = 0; i < paramCount; ++i) {
                if (i > 0) {
                    writer.append(",");
                }
                this.params.get(i).writeShort(writer);
            }
            writer.append(">");
        }
    }

    String shortName() {
        StringBuilder sb = new StringBuilder();
        this.shortName(sb);
        return sb.toString();
    }

    void shortName(StringBuilder sb) {
        sb.append(Util.shortName(this.trimExtends()));
        for (GenericType param : this.params) {
            param.shortName(sb);
        }
    }

    private String trimExtends() {
        String type = this.topType();
        if (type != null && type.startsWith("? extends ")) {
            return type.substring(10);
        }
        if ("?".equals(type)) {
            return "Wildcard";
        }
        return type;
    }

    String topType() {
        return this.mainType != null ? this.mainType : this.raw;
    }

    String mainType() {
        return this.mainType;
    }

    List<GenericType> params() {
        return this.params;
    }

    void setMainType(String mainType) {
        this.mainType = mainType;
    }

    void addParam(GenericType param) {
        this.params.add(param);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericType that = (GenericType)o;
        return this.raw.equals(that.raw);
    }

    public int hashCode() {
        return Objects.hash(this.raw);
    }
}

