/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.DependencyMetaPrism;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class MetaData {
    private static final String NEWLINE = "\n";
    private final String type;
    private final String shortType;
    private final String name;
    private String method;
    private boolean wired;
    private String providesAspect;
    private List<String> provides;
    private List<Dependency> dependsOn;
    private String autoProvides;
    private boolean generateProxy;
    private boolean usesExternalDependency;
    private String externalDependency;

    MetaData(DependencyMetaPrism meta) {
        this.type = meta.type();
        this.name = this.trimName(meta.name());
        this.shortType = Util.shortName(this.type);
        this.method = meta.method();
        this.providesAspect = meta.providesAspect();
        this.provides = meta.provides();
        this.dependsOn = meta.dependsOn().stream().map(Dependency::new).collect(Collectors.toList());
        this.autoProvides = meta.autoProvides();
    }

    MetaData(String type, String name) {
        this.type = type;
        this.name = this.trimName(name);
        this.shortType = Util.shortName(type);
        this.provides = new ArrayList<String>();
        this.dependsOn = new ArrayList<Dependency>();
    }

    public String toString() {
        return this.name == null ? this.type : this.type + ":" + this.name;
    }

    boolean isGenerateProxy() {
        return this.generateProxy;
    }

    private String trimName(String name) {
        return "".equals(name) ? null : name;
    }

    String buildName() {
        if (Util.isVoid(this.type)) {
            return "void_" + Util.trimMethod(this.method);
        }
        String trimType = Util.trimMethod(this.type);
        if (this.name != null) {
            return trimType + "_" + this.name;
        }
        return trimType;
    }

    public String key() {
        if (Util.isVoid(this.type)) {
            return "method:" + this.method;
        }
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean noDepends() {
        return this.dependsOn == null || this.dependsOn.isEmpty();
    }

    boolean isWired() {
        return this.wired;
    }

    void setWired() {
        this.wired = true;
    }

    void update(BeanReader beanReader) {
        this.provides = beanReader.provides();
        this.dependsOn = beanReader.dependsOn();
        this.providesAspect = beanReader.providesAspect();
        this.autoProvides = beanReader.autoProvides();
        this.generateProxy = beanReader.isGenerateProxy();
    }

    String type() {
        return this.type;
    }

    List<String> provides() {
        return this.provides;
    }

    List<Dependency> dependsOn() {
        return this.dependsOn;
    }

    String autoProvides() {
        return this.autoProvides;
    }

    String providesAspect() {
        return this.providesAspect;
    }

    String topPackage() {
        if (this.method == null || this.method.isEmpty()) {
            return Util.packageOf(this.type);
        }
        return null;
    }

    void addImportTypes(Set<String> importTypes) {
        if (this.hasMethod()) {
            importTypes.add(Util.classOfMethod(this.method));
        } else if (!this.generateProxy) {
            importTypes.add(this.type + "$DI");
        }
    }

    void buildMethod(Append append) {
        if (this.generateProxy) {
            return;
        }
        if (this.usesExternalDependency) {
            append.append("  // uses external dependency ").append(this.externalDependency).append(NEWLINE);
        }
        append.append("  @DependencyMeta(type=\"").append(this.type).append("\"");
        if (this.name != null) {
            append.append(", name=\"").append(this.name).append("\"");
        }
        if (this.hasMethod()) {
            append.append(", method=\"").append(this.method).append("\"");
        }
        if (!this.providesAspect.isEmpty()) {
            append.append(", providesAspect=\"").append(this.providesAspect).append("\"");
        } else if (!this.provides.isEmpty()) {
            this.appendProvides(append, "provides", this.provides);
        }
        if (!this.dependsOn.isEmpty()) {
            this.appendProvides(append, "dependsOn", this.dependsOn.stream().map(Dependency::dependsOn).collect(Collectors.toList()));
        }
        if (this.autoProvides != null && !this.autoProvides.isEmpty()) {
            append.append(", autoProvides=\"").append(this.autoProvides).append("\"");
        }
        append.append(")").append(NEWLINE);
        append.append("  private void build_").append(this.buildName()).append("() {").append(NEWLINE);
        if (this.hasMethod()) {
            append.append("    ").append(Util.shortMethod(this.method)).append("(builder");
        } else {
            append.append("    ").append(this.shortType).append("$DI").append(".build(builder");
        }
        append.append(");").append(NEWLINE);
        append.append("  }").append(NEWLINE);
        append.eol();
    }

    private boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    private void appendProvides(Append sb, String attribute, List<String> types) {
        sb.append(", ").append(attribute).append("={");
        for (int i = 0; i < types.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("\"");
            sb.append(types.get(i));
            sb.append("\"");
        }
        sb.append("}");
    }

    void setProvides(List<String> provides) {
        this.provides = provides;
    }

    void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn.stream().map(Dependency::new).collect(Collectors.toList());
    }

    void setMethod(String method) {
        this.method = method;
    }

    void setAutoProvides(String autoProvides) {
        this.autoProvides = autoProvides;
    }

    void setProvidesAspect(String providesAspect) {
        this.providesAspect = providesAspect;
    }

    void markWithExternalDependency(String name) {
        this.usesExternalDependency = true;
        this.externalDependency = name;
    }
}

