/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;

final class MetaDataOrdering {
    private static final String CIRC_ERR_MSG = "To handle circular dependencies consider using field injection rather than constructor injection on one of the dependencies. \n See https://avaje.io/inject/#circular";
    private final ScopeInfo scopeInfo;
    private final List<MetaData> orderedList = new ArrayList<MetaData>();
    private final List<MetaData> queue = new ArrayList<MetaData>();
    private final Map<String, ProviderList> providers = new HashMap<String, ProviderList>();
    private final List<DependencyLink> circularDependencies = new ArrayList<DependencyLink>();
    private final Set<String> missingDependencyTypes = new LinkedHashSet<String>();
    private final Set<String> autoRequires = new TreeSet<String>();
    private final Set<String> autoRequiresAspects = new TreeSet<String>();

    MetaDataOrdering(Collection<MetaData> values, ScopeInfo scopeInfo) {
        this.scopeInfo = scopeInfo;
        for (MetaData metaData : values) {
            if (metaData.noDepends()) {
                this.orderedList.add(metaData);
                metaData.setWired();
            } else {
                this.queue.add(metaData);
            }
            this.providerAdd(metaData.type()).add(metaData);
            for (String provide : metaData.provides()) {
                this.providerAdd(provide).add(metaData);
            }
            String aspect = metaData.providesAspect();
            if (aspect == null || aspect.isEmpty()) continue;
            this.providerAdd(Util.wrapAspect(aspect)).add(metaData);
        }
        this.externallyRequiredDependencies();
    }

    private void externallyRequiredDependencies() {
        for (String requireType : this.scopeInfo.requires()) {
            this.providerAdd(requireType);
        }
        for (String requireType : this.scopeInfo.pluginProvided()) {
            this.providerAdd(requireType);
        }
    }

    private ProviderList providerAdd(String requireType) {
        return this.providers.computeIfAbsent(requireType, s -> new ProviderList());
    }

    int processQueue() {
        int count;
        while ((count = this.processQueueRound(false)) > 0) {
        }
        while ((count = this.processQueueRound(true)) > 0) {
        }
        int remaining = this.queue.size();
        if (remaining != 0) {
            this.missingDependencies();
            this.orderedList.addAll(this.queue);
        }
        return remaining;
    }

    private void detectCircularDependency(List<MetaData> remainder) {
        ArrayList<DependencyLink> dependencyLinks = new ArrayList<DependencyLink>();
        for (MetaData metaData : remainder) {
            List<Dependency> dependsOn = metaData.dependsOn();
            if (dependsOn == null) continue;
            for (Dependency dependency : dependsOn) {
                MetaData provider = this.findCircularDependency(remainder, dependency);
                if (provider == null) continue;
                dependencyLinks.add(new DependencyLink(metaData, provider, dependency.name()));
            }
        }
        if (dependencyLinks.size() > 1) {
            this.circularDependencies.addAll(dependencyLinks);
        }
    }

    private MetaData findCircularDependency(List<MetaData> remainder, Dependency dependency) {
        for (MetaData metaData : remainder) {
            if (metaData.type().equals(dependency.name())) {
                return metaData;
            }
            List<String> provides = metaData.provides();
            if (provides == null || !provides.contains(dependency.name())) continue;
            return metaData;
        }
        return null;
    }

    private void errorOnCircularDependencies() {
        ProcessingContext.logError("Circular dependencies detected with beans %s  %s", this.circularDependencies, CIRC_ERR_MSG);
        for (DependencyLink link : this.circularDependencies) {
            ProcessingContext.logError("Circular dependency - %s dependsOn %s for %s", link.metaData, link.provider, link.dependency);
        }
    }

    void missingDependencies() {
        for (MetaData metaData : this.queue) {
            this.checkMissingDependencies(metaData);
        }
        if (this.missingDependencyTypes.isEmpty()) {
            this.detectCircularDependency(this.queue);
        }
    }

    private void checkMissingDependencies(MetaData metaData) {
        for (Dependency dependency : metaData.dependsOn()) {
            if (this.providers.get(dependency.name()) != null || this.scopeInfo.providedByOtherScope(dependency.name())) continue;
            TypeElement element = ProcessingContext.elementMaybe(metaData.type());
            ProcessingContext.logError(element, "No dependency provided for " + dependency + " on " + metaData.type(), new Object[0]);
            this.missingDependencyTypes.add(dependency.name());
        }
    }

    private void warnOnDependencies() {
        if (!this.missingDependencyTypes.isEmpty()) {
            ProcessingContext.logError("Dependencies %s are not provided - missing @Singleton, @Component, @Factory/@Bean or specify external dependency via @InjectModule requires attribute", this.missingDependencyTypes);
        } else if (!this.queue.isEmpty()) {
            ProcessingContext.logWarn("There are " + this.queue.size() + " beans with unsatisfied dependencies (assuming external dependencies)", new Object[0]);
            for (MetaData m : this.queue) {
                ProcessingContext.logWarn("Unsatisfied dependencies on %s dependsOn %s", m, m.dependsOn());
            }
        }
    }

    void logWarnings() {
        if (this.hasCircularDependencies()) {
            this.errorOnCircularDependencies();
        } else {
            this.warnOnDependencies();
        }
    }

    private int processQueueRound(boolean includeExternal) {
        int count = 0;
        Iterator<MetaData> iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            MetaData queuedMeta = iterator.next();
            if (!this.allDependenciesWired(queuedMeta, includeExternal)) continue;
            this.orderedList.add(queuedMeta);
            queuedMeta.setWired();
            iterator.remove();
            ++count;
        }
        return count;
    }

    private boolean allDependenciesWired(MetaData queuedMeta, boolean includeExternal) {
        for (Dependency dependency : queuedMeta.dependsOn()) {
            String dependencyName = dependency.name();
            if (Util.isProvider(dependencyName) || "io.avaje.inject.BeanScope".equals(dependency.name())) continue;
            ProviderList providerList = this.providers.get(dependencyName);
            if (providerList == null) {
                if (this.scopeInfo.providedByOther(dependency)) continue;
                if (includeExternal && ProcessingContext.externallyProvided(dependencyName)) {
                    if (Util.isAspectProvider(dependencyName)) {
                        this.autoRequiresAspects.add(Util.extractAspectType(dependencyName));
                    } else {
                        this.autoRequires.add(dependencyName);
                    }
                    queuedMeta.markWithExternalDependency(dependencyName);
                    continue;
                }
                return false;
            }
            if (providerList.isAllWired()) continue;
            return false;
        }
        return true;
    }

    Set<String> autoRequires() {
        return this.autoRequires;
    }

    Set<String> autoRequiresAspects() {
        return this.autoRequiresAspects;
    }

    List<MetaData> ordered() {
        return this.orderedList;
    }

    Set<String> importTypes() {
        TreeSet<String> importTypes = new TreeSet<String>();
        for (MetaData metaData : this.orderedList) {
            metaData.addImportTypes(importTypes);
        }
        return importTypes;
    }

    private boolean hasCircularDependencies() {
        return !this.circularDependencies.isEmpty();
    }

    private static class ProviderList {
        private final List<MetaData> list = new ArrayList<MetaData>();

        private ProviderList() {
        }

        void add(MetaData beanMeta) {
            this.list.add(beanMeta);
        }

        boolean isAllWired() {
            for (MetaData metaData : this.list) {
                if (metaData.isWired()) continue;
                return false;
            }
            return true;
        }
    }

    private static class DependencyLink {
        final MetaData metaData;
        final MetaData provider;
        final String dependency;

        DependencyLink(MetaData metaData, MetaData provider, String dependency) {
            this.metaData = metaData;
            this.provider = provider;
            this.dependency = dependency;
        }

        public String toString() {
            return this.metaData.toString();
        }
    }
}

