/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.ExternalProvider;
import io.avaje.inject.generator.ImportPrism;
import io.avaje.inject.generator.InjectModulePrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.ScopePrism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.avaje.inject.InjectModule", "io.avaje.inject.Factory", "jakarta.inject.Singleton", "io.avaje.inject.Component", "io.avaje.inject.Prototype", "jakarta.inject.Scope", "io.avaje.inject.test.TestScope", "io.avaje.http.api.Controller", "io.avaje.inject.Component.Import"})
public final class Processor
extends AbstractProcessor {
    private Elements elementUtils;
    private ScopeInfo defaultScope;
    private AllScopes allScopes;
    private boolean readModuleInfo;
    private final Set<String> pluginFileProvided = new HashSet<String>();
    private final Set<String> moduleFileProvided = new HashSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.loadProvidedFiles(processingEnv.getFiler());
        ProcessingContext.init(processingEnv, this.moduleFileProvided);
        this.elementUtils = processingEnv.getElementUtils();
        this.allScopes = new AllScopes();
        this.defaultScope = this.allScopes.defaultScope();
        ExternalProvider.registerPluginProvidedTypes(this.defaultScope);
        this.pluginFileProvided.forEach(this.defaultScope::pluginProvided);
    }

    void loadProvidedFiles(Filer filer) {
        this.pluginFileProvided.addAll(Processor.lines(filer, "target/avaje-plugin-provides.txt", "/target/classes"));
        this.moduleFileProvided.addAll(Processor.lines(filer, "target/avaje-module-provides.txt", "/target/classes"));
        this.pluginFileProvided.addAll(Processor.lines(filer, "build/avaje-plugin-provides.txt", "/build/classes/java/main"));
        this.moduleFileProvided.addAll(Processor.lines(filer, "build/avaje-module-provides.txt", "/build/classes/java/main"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<String> lines(Filer filer, String relativeName, String replace) {
        try {
            String resource = Processor.resource(filer, relativeName, replace);
            try (InputStream inputStream = new URI(resource).toURL().openStream();){
                List<String> list;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    list = reader.lines().collect(Collectors.toList());
                }
                return list;
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private static String resource(Filer filer, String relativeName, String replace) throws IOException {
        return filer.getResource(StandardLocation.CLASS_OUTPUT, "", relativeName).toUri().toString().replace(replace, "");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.readModule(roundEnv);
        this.readScopes(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("jakarta.inject.Scope")));
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.Factory")), true);
        if (this.defaultScope.includeSingleton()) {
            this.readChangedBeans(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("jakarta.inject.Singleton")), false);
        }
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.Component")), false);
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.Prototype")), false);
        Set importedElements = roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.Component.Import")).stream().map(ImportPrism::getInstanceOn).flatMap(p -> p.value().stream()).map(ProcessingContext::asElement).map(TypeElement.class::cast).collect(Collectors.toSet());
        this.readChangedBeans(importedElements, false);
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.Prototype")), false);
        TypeElement typeElement = this.elementUtils.getTypeElement("io.avaje.http.api.Controller");
        if (typeElement != null) {
            this.readChangedBeans(roundEnv.getElementsAnnotatedWith(typeElement), false);
        }
        this.readChangedBeans(roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.spi.Proxy")), false);
        this.allScopes.readBeans(roundEnv);
        this.defaultScope.write(roundEnv.processingOver());
        this.allScopes.write(roundEnv.processingOver());
        if (roundEnv.processingOver()) {
            ProcessingContext.clear();
        }
        return false;
    }

    private void readScopes(Set<? extends Element> scopes) {
        for (Element element : scopes) {
            if (element.getKind() != ElementKind.ANNOTATION_TYPE || !(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            this.allScopes.addScopeAnnotation(type);
        }
        this.addTestScope();
    }

    private void addTestScope() {
        TypeElement testScopeType = this.elementUtils.getTypeElement("io.avaje.inject.test.TestScope");
        if (testScopeType != null) {
            this.allScopes.addScopeAnnotation(testScopeType);
        }
    }

    private void readChangedBeans(Set<? extends Element> beans, boolean factory) {
        for (Element element : beans) {
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            ScopeInfo scope = this.findScope(typeElement);
            if (!factory) {
                if (scope != null) continue;
                this.defaultScope.read(typeElement, false);
                continue;
            }
            if (scope != null) {
                scope.read(typeElement, true);
                continue;
            }
            this.defaultScope.read(typeElement, true);
        }
    }

    private ScopeInfo findScope(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ScopeInfo scopeInfo = this.allScopes.get(annotationMirror.getAnnotationType().toString());
            if (scopeInfo == null) continue;
            return scopeInfo;
        }
        return null;
    }

    private void readModule(RoundEnvironment roundEnv) {
        TypeElement moduleType;
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        String factory = ProcessingContext.loadMetaInfServices();
        if (factory != null && (moduleType = this.elementUtils.getTypeElement(factory)) != null) {
            this.defaultScope.readModuleMetaData(moduleType);
        }
        this.allScopes.readModules(ProcessingContext.loadMetaInfCustom());
        this.readInjectModule(roundEnv);
    }

    private void readInjectModule(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(ProcessingContext.element("io.avaje.inject.InjectModule"))) {
            InjectModulePrism annotation;
            ScopePrism scope = ScopePrism.getInstanceOn(element);
            if (scope != null || (annotation = InjectModulePrism.getInstanceOn(element)) == null) continue;
            this.defaultScope.details(annotation.name(), element);
        }
    }
}

