/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.DependencyMetaPrism;
import io.avaje.inject.generator.InjectModulePrism;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MetaDataOrdering;
import io.avaje.inject.generator.MetaTopPackage;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeUtil;
import io.avaje.inject.generator.SimpleBeanProxyWriter;
import io.avaje.inject.generator.SimpleBeanWriter;
import io.avaje.inject.generator.SimpleModuleWriter;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

final class ScopeInfo {
    private final Map<String, MetaData> metaData = new LinkedHashMap<String, MetaData>();
    private final Map<String, String> constructorDependencies = new LinkedHashMap<String, String>();
    private final List<BeanReader> beanReaders = new ArrayList<BeanReader>();
    private final Set<String> readBeans = new HashSet<String>();
    private final Set<String> pluginProvided = new HashSet<String>();
    private final Set<String> requires = new LinkedHashSet<String>();
    private final Set<String> provides = new LinkedHashSet<String>();
    private final Set<String> requiresPackages = new LinkedHashSet<String>();
    private final List<String> requirePkg = new ArrayList<String>();
    private final boolean defaultScope;
    private final TypeElement annotationType;
    private final AllScopes scopes;
    private boolean moduleInitialised;
    private boolean moduleWritten;
    private String name;
    private String modulePackage;
    private String moduleFullName;
    private String moduleShortName;
    private JavaFileObject moduleFile;
    private boolean emptyModule;
    private boolean ignoreSingleton;

    ScopeInfo() {
        this.scopes = null;
        this.defaultScope = true;
        this.annotationType = null;
    }

    ScopeInfo(TypeElement type, AllScopes scopes) {
        this.scopes = scopes;
        this.defaultScope = false;
        this.annotationType = type;
    }

    public String toString() {
        return "ScopeInfo{name=" + this.name + ", metaData=" + this.metaData + "}";
    }

    void pluginProvided(String pluginProvides) {
        this.pluginProvided.add(pluginProvides);
    }

    boolean includeSingleton() {
        return !this.ignoreSingleton;
    }

    void details(String name, Element contextElement) {
        if (name == null || name.isEmpty()) {
            String simpleName = contextElement.getSimpleName().toString();
            this.name = ScopeUtil.name(simpleName);
        } else {
            this.name = ScopeUtil.name(name);
        }
        this.read(contextElement);
    }

    private void read(Element element) {
        InjectModulePrism injectModule = InjectModulePrism.getInstanceOn(element);
        if (injectModule == null) {
            return;
        }
        this.ignoreSingleton = injectModule.ignoreSingleton();
        injectModule.requires().stream().map(Object::toString).forEach(this.requires::add);
        injectModule.provides().stream().map(Object::toString).forEach(this.provides::add);
        injectModule.requiresPackages().stream().map(Object::toString).forEach(require -> {
            this.requiresPackages.add((String)require);
            this.requirePkg.add(Util.packageOf(require) + ".");
        });
    }

    private String initName(String topPackage) {
        if (this.name == null || this.name.isEmpty()) {
            this.name = ScopeUtil.initName(topPackage);
        }
        return this.name;
    }

    void initialiseName(String topPackage) throws IOException {
        boolean bl = this.emptyModule = topPackage == null;
        if (!this.emptyModule) {
            this.modulePackage = topPackage;
            String name = this.initName(this.modulePackage);
            this.moduleShortName = name + "Module";
            this.moduleFullName = this.modulePackage + "." + this.moduleShortName;
            this.moduleFile = ProcessingContext.createWriter(this.moduleFullName);
        }
    }

    JavaFileObject moduleFile() {
        return this.moduleFile;
    }

    String modulePackage() {
        return this.modulePackage;
    }

    String moduleFullName() {
        return this.moduleFullName;
    }

    String moduleShortName() {
        return this.moduleShortName;
    }

    String name() {
        return this.name;
    }

    Set<String> requires() {
        return this.requires;
    }

    Set<String> pluginProvided() {
        return this.pluginProvided;
    }

    void writeBeanHelpers() {
        for (BeanReader beanReader : this.beanReaders) {
            try {
                if (beanReader.isWrittenToFile()) continue;
                if (beanReader.isGenerateProxy()) {
                    SimpleBeanProxyWriter proxyWriter = new SimpleBeanProxyWriter(beanReader);
                    proxyWriter.write();
                } else {
                    SimpleBeanWriter writer = new SimpleBeanWriter(beanReader);
                    writer.write();
                }
                beanReader.setWrittenToFile();
            }
            catch (FilerException e) {
                ProcessingContext.logWarn("FilerException to write $DI class " + beanReader.beanType() + " " + e.getMessage(), new Object[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                ProcessingContext.logError(beanReader.beanType(), "Failed to write $DI class", new Object[0]);
            }
        }
    }

    private void initialiseModule() {
        if (!this.moduleInitialised) {
            try {
                this.initialiseName(MetaTopPackage.of(this.metaData.values()));
                ProcessingContext.addModule(this.moduleFullName);
                this.moduleInitialised = true;
            }
            catch (IOException e) {
                if (ProcessingContext.isDuplicateModule(this.moduleFullName)) {
                    String msg = "Attempting to create 2 modules both called " + this.moduleFullName + ". This can occur when a custom scope (named from it's annotation) has a name clash with the default module which can be named from the package. Look to resolve this by either changing the name of the custom scope annotation, or explicitly naming the default scope using @InjectModule(name), or changing the top level package used by the default scope";
                    throw new IllegalStateException(msg);
                }
                ProcessingContext.logError("Failed to create module filer " + e.getMessage(), new Object[0]);
            }
        }
    }

    void writeModule() {
        if (this.moduleWritten) {
            return;
        }
        Collection<MetaData> meta = this.metaData.values();
        if (this.emptyModule) {
            if (meta.size() > 0) {
                String msg = meta + " is being ignored by avaje-inject as there is no 'default' module. This is expected when " + meta + " is a @Singleton being generated by an annotation processor but there is no 'default' module (only custom modules are being used).";
                ProcessingContext.logWarn(msg, new Object[0]);
            }
            return;
        }
        MetaDataOrdering ordering = new MetaDataOrdering(meta, this);
        int remaining = ordering.processQueue();
        if (remaining > 0) {
            ordering.logWarnings();
        }
        try {
            SimpleModuleWriter factoryWriter = new SimpleModuleWriter(ordering, this);
            factoryWriter.write(this.type());
            this.moduleWritten = true;
        }
        catch (FilerException e) {
            ProcessingContext.logWarn("FilerException trying to write factory " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            ProcessingContext.logError("Failed to write factory " + e.getMessage(), new Object[0]);
        }
    }

    Type type() {
        return this.annotationType == null ? Type.DEFAULT : ("io.avaje.inject.test.TestScope".equals(this.annotationType.getQualifiedName().toString()) ? Type.TEST : Type.CUSTOM);
    }

    void mergeMetaData() {
        for (BeanReader beanReader : this.beanReaders) {
            if (beanReader.isRequestScopedController()) continue;
            MetaData metaData = this.metaData.get(beanReader.metaKey());
            if (metaData == null) {
                this.addMeta(beanReader);
                continue;
            }
            this.updateMeta(metaData, beanReader);
        }
    }

    private void addMeta(BeanReader beanReader) {
        MetaData meta = beanReader.createMeta();
        this.metaData.put(meta.key(), meta);
        for (MetaData methodMeta : beanReader.createFactoryMethodMeta()) {
            this.metaData.put(methodMeta.key(), methodMeta);
        }
    }

    private void updateMeta(MetaData metaData, BeanReader beanReader) {
        metaData.update(beanReader);
    }

    private void readBeanMeta(TypeElement typeElement, boolean factory) {
        if (typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            ProcessingContext.logDebug("skipping annotation type " + typeElement, new Object[0]);
            return;
        }
        this.beanReaders.add(new BeanReader(typeElement, factory).read());
    }

    void readBuildMethodDependencyMeta(Element element) {
        Name simpleName = element.getSimpleName();
        if (simpleName.toString().startsWith("build_")) {
            DependencyMetaPrism meta = DependencyMetaPrism.getInstanceOn(element);
            if (meta == null) {
                ProcessingContext.logError("Missing @DependencyMeta on method " + simpleName, new Object[0]);
            } else {
                MetaData metaData = new MetaData(meta);
                this.metaData.put(metaData.key(), metaData);
            }
        }
    }

    void read(TypeElement element, boolean factory) {
        if (this.readBeans.add(element.toString())) {
            this.readBeanMeta(element, factory);
        } else {
            ProcessingContext.logDebug("skipping already processed bean " + element, new Object[0]);
        }
    }

    void writeCustomModule() {
        if (this.type() == Type.CUSTOM && !this.metaData.isEmpty()) {
            this.writeModule();
        }
    }

    void write(boolean processingOver) {
        this.mergeMetaData();
        this.writeBeanHelpers();
        this.initialiseModule();
        if (processingOver && !this.metaData.isEmpty()) {
            this.writeModule();
        }
    }

    void buildAtInjectModule(Append writer) {
        writer.append("@Generated(\"io.avaje.inject.generator\")").eol();
        writer.append("@InjectModule(");
        boolean leadingComma = false;
        if (!this.provides.isEmpty()) {
            this.attributeClasses(false, writer, "provides", this.provides);
            leadingComma = true;
        }
        if (!this.requires.isEmpty()) {
            this.attributeClasses(leadingComma, writer, "requires", this.requires);
            leadingComma = true;
        }
        if (!this.requiresPackages.isEmpty()) {
            this.attributeClasses(leadingComma, writer, "requiresPackages", this.requiresPackages);
            leadingComma = true;
        }
        if (this.annotationType != null) {
            if (leadingComma) {
                writer.append(", ");
            }
            writer.append("customScopeType=\"%s\"", this.annotationType.getQualifiedName().toString());
        }
        writer.append(")").eol();
    }

    private void attributeClasses(boolean leadingComma, Append writer, String prefix, Set<String> classNames) {
        if (leadingComma) {
            writer.append(", ");
        }
        writer.append("%s={", prefix);
        int c = 0;
        for (String value : classNames) {
            if (c++ > 0) {
                writer.append(",");
            }
            writer.append(value).append(".class");
        }
        writer.append("}");
    }

    void buildProvides(Append writer) {
        if (!this.provides.isEmpty()) {
            this.buildProvidesMethod(writer, "provides", this.provides);
        }
        if (!this.requires.isEmpty()) {
            this.buildProvidesMethod(writer, "requires", this.requires);
        }
        if (!this.requiresPackages.isEmpty()) {
            this.buildProvidesMethod(writer, "requiresPackages", this.requiresPackages);
        }
    }

    private void buildProvidesMethod(Append writer, String fieldName, Set<String> types) {
        writer.append("  @Override").eol();
        writer.append("  public Class<?>[] %s() { return %s; }", fieldName, fieldName).eol();
        writer.append("  private final Class<?>[] %s = new Class<?>[]{", fieldName).eol();
        for (String rawType : types) {
            writer.append("    %s.class,", rawType).eol();
        }
        writer.append("  };").eol().eol();
    }

    void buildAutoProvides(Append writer, Set<String> autoProvides) {
        autoProvides.removeAll(this.provides);
        if (!autoProvides.isEmpty()) {
            this.buildProvidesMethod(writer, "autoProvides", autoProvides);
        }
    }

    void buildAutoProvidesAspects(Append writer, Set<String> autoProvidesAspects) {
        autoProvidesAspects.removeAll(this.provides);
        if (!autoProvidesAspects.isEmpty()) {
            this.buildProvidesMethod(writer, "autoProvidesAspects", autoProvidesAspects);
        }
    }

    void buildAutoRequires(Append writer, Set<String> autoRequires) {
        autoRequires.removeAll(this.requires);
        if (!autoRequires.isEmpty()) {
            this.buildProvidesMethod(writer, "autoRequires", autoRequires);
        }
    }

    void buildAutoRequiresAspects(Append writer, Set<String> autoRequires) {
        autoRequires.removeAll(this.requires);
        if (!autoRequires.isEmpty()) {
            this.buildProvidesMethod(writer, "autoRequiresAspects", autoRequires);
        }
    }

    void readModuleMetaData(TypeElement moduleType) {
        InjectModulePrism module = InjectModulePrism.getInstanceOn(moduleType);
        this.details(module.name(), moduleType);
        this.readFactoryMetaData(moduleType);
    }

    private void readFactoryMetaData(TypeElement moduleType) {
        List<? extends Element> elements = moduleType.getEnclosedElements();
        if (elements != null) {
            for (Element element : elements) {
                if (ElementKind.METHOD != element.getKind()) continue;
                this.readBuildMethodDependencyMeta(element);
            }
        }
    }

    boolean providedByOtherScope(String dependency) {
        if (this.defaultScope) {
            return false;
        }
        if (this.scopes.providedByDefaultScope(dependency)) {
            return true;
        }
        return this.providesDependencyRecursive(dependency);
    }

    private boolean providesDependencyRecursive(String dependency) {
        if (this.providesDependencyLocally(dependency)) {
            return true;
        }
        for (String require : this.requires) {
            ScopeInfo requiredScope = this.scopes.get(require);
            if (requiredScope == null || !requiredScope.providesDependencyRecursive(dependency)) continue;
            return true;
        }
        return false;
    }

    boolean providesDependencyLocally(String dependency) {
        if (this.requires.contains(dependency) || this.pluginProvided.contains(dependency)) {
            return true;
        }
        String aspectDependency = this.aspectDependency(dependency);
        for (MetaData meta : this.metaData.values()) {
            if (dependency.equals(meta.type())) {
                return true;
            }
            if (aspectDependency != null) {
                if (!aspectDependency.equals(meta.providesAspect())) continue;
                return true;
            }
            List<String> provides = meta.provides();
            if (provides == null || provides.isEmpty()) continue;
            for (String provide : provides) {
                if (!dependency.equals(provide)) continue;
                return true;
            }
        }
        return false;
    }

    private String aspectDependency(String dependency) {
        if (Util.isAspectProvider(dependency)) {
            return Util.extractAspectType(dependency);
        }
        return null;
    }

    boolean providedByPackage(String dependency) {
        for (String pkg : this.requirePkg) {
            if (!dependency.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    boolean providedByOther(Dependency dependency) {
        return dependency.isSoftDependency() || this.providedByPackage(dependency.name()) || this.providedByOtherScope(dependency.name());
    }

    Set<String> initModuleDependencies(Set<String> importTypes) {
        if (this.defaultScope || this.requires.isEmpty()) {
            return importTypes;
        }
        for (String require : this.requires) {
            ScopeInfo otherScope = this.scopes.get(require);
            if (otherScope != null) continue;
            importTypes.add(require);
            String type = Util.shortName(require);
            String var = Util.initLower(type);
            this.constructorDependencies.put(type, var);
        }
        return importTypes;
    }

    boolean addModuleConstructor() {
        return !this.constructorDependencies.isEmpty();
    }

    Map<String, String> constructorDependencies() {
        return this.constructorDependencies;
    }

    boolean addWithBeans() {
        return !this.constructorDependencies.isEmpty();
    }

    static enum Type {
        DEFAULT("Module"),
        CUSTOM("Module.Custom"),
        TEST("io.avaje.inject.test.TestModule");

        final String type;

        private Type(String type) {
            this.type = type;
        }

        String type() {
            return this.type;
        }
    }
}

