/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.IncludeAnnotations;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.QualifierPrism;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class TypeAnnotationReader {
    private final TypeElement beanType;
    private final List<String> annotationTypes = new ArrayList<String>();
    private String qualifierName;

    TypeAnnotationReader(TypeElement beanType) {
        this.beanType = beanType;
    }

    List<String> annotationTypes() {
        return this.annotationTypes;
    }

    boolean hasQualifierName() {
        return this.qualifierName != null;
    }

    String qualifierName() {
        return this.qualifierName;
    }

    void process() {
        for (AnnotationMirror annotationMirror : this.beanType.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            String annType = annotationType.toString();
            if (QualifierPrism.isPresent(annotationType.asElement())) {
                this.qualifierName = Util.shortName(annType).toLowerCase();
                continue;
            }
            if (annType.indexOf(46) == -1) {
                ProcessingContext.logWarn("skip when no package on annotation " + annType, new Object[0]);
                continue;
            }
            if (!IncludeAnnotations.include(annType)) continue;
            this.annotationTypes.add(annType);
        }
    }
}

