/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.FactoryPrism;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GeneratedPrism;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.TypeExtendsInjection;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class TypeExtendsReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_RECORD = "java.lang.Record";
    private final GenericType baseGenericType;
    private final TypeElement baseType;
    private final TypeExtendsInjection extendsInjection;
    private final List<String> extendsTypes = new ArrayList<String>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private final List<String> providesTypes = new ArrayList<String>();
    private final String beanSimpleName;
    private final String baseTypeRaw;
    private final boolean baseTypeIsInterface;
    private final boolean publicAccess;
    private final boolean autoProvide;
    private boolean closeable;
    private String qualifierName;
    private String providesAspect = "";

    TypeExtendsReader(GenericType baseGenericType, TypeElement baseType, boolean factory, ImportTypeMap importTypes) {
        this.baseGenericType = baseGenericType;
        this.baseType = baseType;
        this.extendsInjection = new TypeExtendsInjection(baseType, factory, importTypes);
        this.beanSimpleName = baseType.getSimpleName().toString();
        this.baseTypeRaw = Util.unwrapProvider(baseGenericType.toString());
        this.baseTypeIsInterface = baseType.getKind() == ElementKind.INTERFACE;
        this.publicAccess = baseType.getModifiers().contains((Object)Modifier.PUBLIC);
        this.autoProvide = this.autoProvide();
    }

    private boolean autoProvide() {
        return this.publicAccess && !FactoryPrism.isPresent(this.baseType) && !ProxyPrism.isPresent(this.baseType) && !GeneratedPrism.isPresent(this.baseType) && !this.isController();
    }

    private boolean isController() {
        try {
            return this.baseType.getAnnotation(Class.forName("io.avaje.http.api.Controller")) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    GenericType baseType() {
        return this.baseGenericType;
    }

    String qualifierName() {
        return this.qualifierName;
    }

    BeanAspects hasAspects() {
        return this.extendsInjection.hasAspects();
    }

    List<FieldReader> injectFields() {
        return this.extendsInjection.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.extendsInjection.injectMethods();
    }

    List<MethodReader> factoryMethods() {
        return this.extendsInjection.factoryMethods();
    }

    Element postConstructMethod() {
        return this.extendsInjection.postConstructMethod();
    }

    Element preDestroyMethod() {
        return this.extendsInjection.preDestroyMethod();
    }

    MethodReader constructor() {
        return this.extendsInjection.constructor();
    }

    String providesAspect() {
        return this.providesAspect;
    }

    String autoProvides() {
        if (!this.autoProvide || !this.providesAspect.isEmpty()) {
            return null;
        }
        if (this.baseTypeIsInterface || this.interfaceTypes.isEmpty()) {
            return this.baseTypeRaw;
        }
        return this.interfaceTypes.get(0);
    }

    List<String> provides() {
        return this.providesTypes;
    }

    boolean isCloseable() {
        return this.closeable;
    }

    void process(boolean forBean) {
        this.extendsTypes.add(this.baseTypeRaw);
        if (forBean) {
            this.extendsInjection.read(this.baseType);
        }
        this.readInterfaces(this.baseType);
        TypeElement superElement = this.superOf(this.baseType);
        if (superElement != null) {
            String superName;
            String baseName;
            if (this.qualifierName == null && (baseName = this.baseType.getSimpleName().toString()).endsWith(superName = superElement.getSimpleName().toString())) {
                this.qualifierName = baseName.substring(0, baseName.length() - superName.length()).toLowerCase();
            }
            this.addSuperType(superElement);
        }
        this.providesTypes.addAll(this.extendsTypes);
        this.providesTypes.addAll(this.interfaceTypes);
        this.providesTypes.remove(this.baseTypeRaw);
        this.extendsInjection.removeFromProvides(this.providesTypes);
        this.providesAspect = this.initProvidesAspect();
    }

    private String initProvidesAspect() {
        for (String providesType : this.providesTypes) {
            if (!Util.isAspectProvider(providesType)) continue;
            return Util.extractAspectType(providesType);
        }
        return "";
    }

    private void addSuperType(TypeElement element) {
        this.readInterfaces(element);
        String fullName = element.getQualifiedName().toString();
        if (!fullName.equals(JAVA_LANG_OBJECT) && !fullName.equals(JAVA_LANG_RECORD)) {
            String type = Util.unwrapProvider(fullName);
            if (this.isPublic(element)) {
                this.extendsTypes.add(type);
                this.extendsInjection.read(element);
            }
            this.addSuperType(this.superOf(element));
        }
    }

    private TypeElement superOf(TypeElement element) {
        return (TypeElement)ProcessingContext.asElement(element.getSuperclass());
    }

    private void readInterfaces(TypeElement type) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            if (!this.isPublic(ProcessingContext.asElement(typeMirror))) continue;
            this.readInterfacesOf(typeMirror);
        }
    }

    private void readInterfacesOf(TypeMirror anInterface) {
        String rawType = Util.unwrapProvider(anInterface.toString());
        if (!JAVA_LANG_OBJECT.equals(rawType)) {
            if (rawType.indexOf(46) == -1) {
                ProcessingContext.logWarn("skip when no package on interface " + rawType, new Object[0]);
            } else if ("java.lang.AutoCloseable".equals(rawType) || "java.io.Closeable".equals(rawType)) {
                this.closeable = true;
            } else {
                String mainType;
                String string;
                if (this.qualifierName == null && this.beanSimpleName.endsWith(string = Util.shortName(mainType = GenericType.removeParameter(rawType)))) {
                    this.qualifierName = this.beanSimpleName.substring(0, this.beanSimpleName.length() - string.length()).toLowerCase();
                }
                this.interfaceTypes.add(rawType);
                if (!rawType.startsWith("java.lang.")) {
                    for (TypeMirror typeMirror : ProcessingContext.types().directSupertypes(anInterface)) {
                        this.readInterfacesOf(typeMirror);
                    }
                }
            }
        }
    }

    private boolean isPublic(Element element) {
        return element != null && element.getModifiers().contains((Object)Modifier.PUBLIC);
    }
}

