/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

final class InjectModulePrism {
    private final String _name;
    private final Boolean _ignoreSingleton;
    private final List<TypeMirror> _provides;
    private final List<TypeMirror> _requires;
    private final List<TypeMirror> _requiresPackages;
    private final String _customScopeType;
    public static final String PRISM_TYPE = "io.avaje.inject.InjectModule";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isInstance(AnnotationMirror mirror) {
        return InjectModulePrism.getInstance(mirror) != null;
    }

    static boolean isPresent(Element element) {
        return InjectModulePrism.getInstanceOn(element) != null;
    }

    static InjectModulePrism getInstanceOn(Element element) {
        AnnotationMirror mirror = InjectModulePrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return InjectModulePrism.getInstance(mirror);
    }

    static Optional<InjectModulePrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = InjectModulePrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return InjectModulePrism.getOptional(mirror);
    }

    static InjectModulePrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new InjectModulePrism(mirror);
    }

    static Optional<InjectModulePrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new InjectModulePrism(mirror));
    }

    private InjectModulePrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._name = this.getValue("name", String.class);
        this._ignoreSingleton = this.getValue("ignoreSingleton", Boolean.class);
        this._provides = this.getArrayValues("provides", TypeMirror.class);
        this._requires = this.getArrayValues("requires", TypeMirror.class);
        this._requiresPackages = this.getArrayValues("requiresPackages", TypeMirror.class);
        this._customScopeType = this.getValue("customScopeType", String.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public String name() {
        return this._name;
    }

    public Boolean ignoreSingleton() {
        return this._ignoreSingleton;
    }

    public List<TypeMirror> provides() {
        return this._provides;
    }

    public List<TypeMirror> requires() {
        return this._requires;
    }

    public List<TypeMirror> requiresPackages() {
        return this._requiresPackages;
    }

    public String customScopeType() {
        return this._customScopeType;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = InjectModulePrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private <T> List<T> getArrayValues(String name, Class<T> clazz) {
        List<T> result = InjectModulePrism.getArrayValues(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    private static <T> List<T> getArrayValues(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return List.of();
        }
        if (av.getValue() instanceof List) {
            ArrayList<T> result = new ArrayList<T>();
            for (AnnotationValue v : InjectModulePrism.getValueAsList(av)) {
                if (clazz.isInstance(v.getValue())) {
                    result.add(clazz.cast(v.getValue()));
                    continue;
                }
                return List.of();
            }
            return result;
        }
        return List.of();
    }

    private static List<AnnotationValue> getValueAsList(AnnotationValue av) {
        return (List)av.getValue();
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue name() {
            return this.values.get("name");
        }

        AnnotationValue ignoreSingleton() {
            return this.values.get("ignoreSingleton");
        }

        AnnotationValue provides() {
            return this.values.get("provides");
        }

        AnnotationValue requires() {
            return this.values.get("requires");
        }

        AnnotationValue requiresPackages() {
            return this.values.get("requiresPackages");
        }

        AnnotationValue customScopeType() {
            return this.values.get("customScopeType");
        }
    }
}

