/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanConditions;
import io.avaje.inject.generator.BeanPrism;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.ConditionalWriter;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodLifecycleReader;
import io.avaje.inject.generator.PrimaryPrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.PrototypePrism;
import io.avaje.inject.generator.QualifiedMapPrism;
import io.avaje.inject.generator.SecondaryPrism;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

final class MethodReader {
    private static final String CODE_COMMENT_BUILD_FACTORYBEAN = "  /**\n   * Create and register %s via factory bean method %s#%s().\n   */";
    private final ExecutableElement element;
    private final String factoryType;
    private final String methodName;
    private final boolean prototype;
    private final boolean primary;
    private final boolean secondary;
    private final String returnTypeRaw;
    private final GenericType genericType;
    private final String shortName;
    private final boolean isVoid;
    private final List<MethodParam> params = new ArrayList<MethodParam>();
    private final String factoryShortName;
    private final String initMethod;
    private final String destroyMethod;
    private final Integer destroyPriority;
    private final boolean beanCloseable;
    private final String name;
    private final TypeReader typeReader;
    private final boolean optionalType;
    private final BeanConditions conditions = new BeanConditions();

    MethodReader(ExecutableElement element, TypeElement beanType, ImportTypeMap importTypes) {
        this(element, beanType, null, null, importTypes);
    }

    MethodReader(ExecutableElement element, TypeElement beanType, BeanPrism bean, String qualifierName, ImportTypeMap importTypes) {
        this.element = element;
        if (bean != null) {
            this.prototype = PrototypePrism.isPresent(element);
            this.primary = PrimaryPrism.isPresent(element);
            this.secondary = SecondaryPrism.isPresent(element);
            this.conditions.readAll(element);
        } else {
            this.prototype = false;
            this.primary = false;
            this.secondary = false;
        }
        this.methodName = element.getSimpleName().toString();
        TypeMirror returnMirror = element.getReturnType();
        String raw = returnMirror.toString();
        if (Util.isOptional(raw)) {
            this.optionalType = true;
            this.returnTypeRaw = GenericType.trimWildcard(Util.extractOptionalType(raw));
        } else {
            this.optionalType = false;
            this.returnTypeRaw = GenericType.trimWildcard(raw);
        }
        this.genericType = GenericType.parse(this.returnTypeRaw);
        String topType = this.genericType.topType();
        this.shortName = Util.shortName(topType);
        this.factoryType = beanType.getQualifiedName().toString();
        this.factoryShortName = Util.shortName(this.factoryType);
        this.isVoid = Util.isVoid(topType);
        String initMethod = bean == null ? null : bean.initMethod();
        String destroyMethod = bean == null ? null : bean.destroyMethod();
        this.destroyPriority = bean == null ? null : bean.destroyPriority();
        this.beanCloseable = bean != null && bean.autoCloseable() != false;
        this.name = qualifierName;
        TypeElement returnElement = ProcessingContext.asElement(returnMirror);
        if (returnElement == null) {
            this.typeReader = null;
            this.initMethod = initMethod;
            this.destroyMethod = destroyMethod;
        } else {
            this.typeReader = new TypeReader(this.genericType, returnElement, importTypes);
            this.typeReader.process();
            MethodLifecycleReader lifecycleReader = new MethodLifecycleReader(returnElement, initMethod, destroyMethod);
            this.initMethod = lifecycleReader.initMethod();
            this.destroyMethod = lifecycleReader.destroyMethod();
        }
    }

    public String toString() {
        return "MethodReader{element=" + String.valueOf(this.element) + ", params=" + String.valueOf(this.params) + "}";
    }

    void addDependsOnGeneric(Set<GenericType> set) {
        for (MethodParam param : this.params) {
            param.addDependsOnGeneric(set);
        }
        if (this.genericType.isGenericType()) {
            set.add(this.genericType);
        }
        if (this.typeReader != null) {
            set.addAll(this.typeReader.genericTypes());
        }
    }

    MethodReader read() {
        List<? extends VariableElement> ps = this.element.getParameters();
        for (VariableElement variableElement : ps) {
            this.params.add(new MethodParam(variableElement));
        }
        return this;
    }

    String name() {
        return this.methodName;
    }

    List<MethodParam> params() {
        return this.params;
    }

    MetaData createMeta() {
        MetaData metaData = new MetaData(this.returnTypeRaw, this.name);
        metaData.setMethod(this.fullBuildMethod());
        ArrayList<String> dependsOn = new ArrayList<String>(this.params.size() + 1);
        dependsOn.add(this.factoryType);
        this.conditions.requireTypes.stream().map(t -> "con:" + t).forEach(dependsOn::add);
        this.conditions.missingTypes.stream().filter(t -> !t.equals(this.returnTypeRaw)).map(t -> "con:" + t).forEach(dependsOn::add);
        for (MethodParam param : this.params) {
            dependsOn.add(GenericType.trimWildcard(param.paramType));
        }
        metaData.setDependsOn(dependsOn);
        metaData.setProvides(this.typeReader == null ? Collections.emptyList() : this.typeReader.provides());
        metaData.setAutoProvides(this.typeReader == null ? null : this.typeReader.autoProvides());
        metaData.setProvidesAspect(this.typeReader == null ? "" : this.typeReader.providesAspect());
        return metaData;
    }

    private String fullBuildMethod() {
        return this.factoryType + "$DI.build_" + this.element.getSimpleName().toString();
    }

    void builderGetFactory(Append writer, boolean factoryHasConditions) {
        if (factoryHasConditions) {
            writer.append("      var factory = builder.getNullable(%s.class);", this.factoryShortName).eol();
            writer.append("      if (factory == null) return;").eol();
        } else {
            writer.append("      var factory = builder.get(%s.class);", this.factoryShortName).eol();
        }
    }

    void builderBuildBean(Append writer) {
        writer.indent("      ");
        if (this.isVoid) {
            writer.append("factory.%s(", this.methodName);
        } else {
            String beanName = this.optionalType ? "optionalBean" : "bean";
            writer.append("var %s = factory.%s(", beanName, this.methodName);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).builderGetDependency(writer, "builder");
        }
        writer.append(");").eol();
    }

    void builderAddBeanProvider(Append writer) {
        if (this.isVoid) {
            writer.append("Error - void @Prototype method ?").eol();
            return;
        }
        if (this.optionalType) {
            writer.append("Error - Optional type with @Prototype method is not supported").eol();
            return;
        }
        String indent = "    ";
        if (this.prototype) {
            writer.indent(indent).append("  builder.asPrototype().registerProvider(() -> {").eol();
        } else {
            writer.indent(indent).append("  builder.asSecondary().registerProvider(() -> {").eol();
        }
        writer.indent(indent).append("    return ");
        writer.append("factory.%s(", this.methodName);
        for (int i = 0; i < this.params.size(); ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).builderGetDependency(writer, "builder");
        }
        writer.append(");").eol();
        writer.indent(indent).append("  });").eol();
        writer.indent(indent).append("}").eol();
    }

    void builderBuildAddBean(Append writer) {
        if (!this.isVoid) {
            String priority;
            if (this.optionalType) {
                writer.append("      if (optionalBean.isPresent()) {").eol();
                writer.append("        var bean = optionalBean.get();").eol();
            }
            String indent = this.optionalType ? "        " : "      ";
            writer.indent(indent);
            if (this.hasLifecycleMethods()) {
                writer.append("var $bean = ");
            }
            writer.append("builder");
            if (this.primary) {
                writer.append(".asPrimary()");
            } else if (this.secondary) {
                writer.append(".asSecondary()");
            }
            writer.append(".register(bean);").eol();
            if (this.notEmpty(this.initMethod)) {
                writer.indent(indent).append("builder.addPostConstruct($bean::%s);", this.initMethod).eol();
            }
            String string = priority = this.destroyPriority == null || this.destroyPriority == 1000 ? "" : ", " + this.destroyPriority;
            if (this.notEmpty(this.destroyMethod)) {
                writer.indent(indent).append("builder.addPreDestroy($bean::%s%s);", this.destroyMethod, priority).eol();
            } else if (this.typeReader != null && this.typeReader.isClosable()) {
                writer.indent(indent).append("builder.addPreDestroy($bean::close%s);", priority).eol();
            } else if (this.beanCloseable) {
                writer.indent(indent).append("builder.addAutoClosable($bean);").eol();
            }
            if (this.optionalType) {
                writer.append("      }").eol();
            }
        }
    }

    private boolean hasLifecycleMethods() {
        return this.notEmpty(this.initMethod) || this.notEmpty(this.destroyMethod) || this.typeReader != null && this.typeReader.isClosable() || this.beanCloseable;
    }

    private boolean notEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    void addImports(ImportTypeMap importTypes) {
        for (MethodParam param : this.params) {
            param.addImports(importTypes);
        }
        if (this.optionalType) {
            importTypes.add("java.util.Optional");
        }
        this.conditions.addImports(importTypes);
    }

    Set<GenericType> genericTypes() {
        return this.typeReader == null ? Collections.emptySet() : this.typeReader.genericTypes();
    }

    void buildConditional(Append writer) {
        new ConditionalWriter(writer, this.conditions).write();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.isVoid) {
            writer.append("Void.class");
        } else {
            if (this.name != null && !this.name.isEmpty()) {
                writer.append("\"%s\", ", this.name);
            }
            if (this.typeReader != null) {
                writer.append(this.typeReader.typesRegister());
            }
        }
        writer.append(")) {").eol();
    }

    boolean methodThrows() {
        return !this.element.getThrownTypes().isEmpty();
    }

    void startTry(Append writer) {
        if (this.methodThrows()) {
            writer.append("      try {").eol();
            writer.setExtraIndent("  ");
        }
    }

    void endTry(Append writer) {
        if (this.methodThrows()) {
            writer.setExtraIndent(null);
            writer.append("      } catch (Throwable e) {").eol();
            writer.append("        throw new RuntimeException(\"Error during wiring\", e);").eol();
            writer.append("      }").eol();
        }
    }

    void checkRequest(BeanRequestParams requestParams) {
        for (MethodParam param : this.params) {
            param.checkRequest(requestParams);
        }
    }

    void writeRequestDependency(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestDependency(writer);
        }
    }

    void writeRequestConstructor(Append writer) {
        for (MethodParam param : this.params) {
            param.writeRequestConstructor(writer);
        }
    }

    public void commentBuildMethod(Append writer) {
        writer.append(CODE_COMMENT_BUILD_FACTORYBEAN, this.shortName, this.factoryShortName, this.methodName).eol();
    }

    boolean isProtoType() {
        return this.prototype;
    }

    boolean isUseProviderForSecondary() {
        return this.secondary && !this.optionalType;
    }

    boolean isPublic() {
        return this.element.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    boolean isNotPrivate() {
        return !this.element.getModifiers().contains((Object)Modifier.PRIVATE);
    }

    void writeConstructorParams(Append writer) {
        for (MethodParam param : this.params) {
            writer.append(", ");
            param.writeMethodParam(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        int size = this.params.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                writer.append(", ");
            }
            this.params.get(i).writeConstructorInit(writer);
        }
    }

    void removeFromProvides(List<String> provides) {
        for (MethodParam param : this.params) {
            param.removeFromProvides(provides);
        }
    }

    static class MethodParam {
        private final VariableElement element;
        private final String named;
        private final UtilType utilType;
        private final String paramType;
        private final GenericType genericType;
        private final GenericType fullGenericType;
        private final boolean nullable;
        private final String simpleName;
        private boolean requestParam;
        private String requestParamName;
        private final boolean isBeanMap;

        MethodParam(VariableElement param) {
            this.element = param;
            this.simpleName = param.getSimpleName().toString();
            this.named = Util.getNamed(param);
            this.nullable = Util.isNullable(param);
            this.utilType = Util.determineType(param.asType());
            this.isBeanMap = QualifiedMapPrism.isPresent(param);
            this.paramType = this.utilType.rawType(this.isBeanMap);
            this.genericType = GenericType.parse(this.paramType);
            this.fullGenericType = GenericType.parse(this.utilType.full());
            if (this.nullable || param.asType().toString().startsWith("java.util.Optional<")) {
                ProcessingContext.addOptionalType(this.paramType);
            }
        }

        public String toString() {
            return "MethodParam{" + String.valueOf(this.fullGenericType) + "}";
        }

        void addDependsOnGeneric(Set<GenericType> set) {
            if (this.genericType.isGenericType() && !this.genericType.isProviderType()) {
                set.add(this.genericType);
            }
        }

        void builderGetDependency(Append writer, String builderName) {
            writer.append(builderName).append(".").append(this.utilType.getMethod(this.nullable, this.isBeanMap));
            if (!this.genericType.isGenericType()) {
                writer.append(Util.shortName(this.genericType.topType())).append(".class");
            } else if (this.isProvider()) {
                writer.append(this.providerParam()).append(".class");
            } else {
                writer.append("TYPE_").append(this.genericType.shortName().replace(".", "_"));
            }
            if (this.named != null && !this.named.isEmpty()) {
                writer.append(",\"").append(this.named).append("\"");
            } else if (!this.isGenericParam() && this.utilType.allowsNamedQualifier()) {
                writer.append(",\"!");
                String shortName = Util.shortName(this.paramType);
                if (this.simpleName.endsWith(shortName)) {
                    writer.append(this.simpleName, 0, this.simpleName.length() - shortName.length());
                } else {
                    writer.append(this.simpleName);
                }
                writer.append("\"");
            }
            writer.append(")");
        }

        private String providerParam() {
            return Util.shortName(Util.unwrapProvider(this.paramType));
        }

        String simpleName() {
            return this.simpleName;
        }

        boolean isProvider() {
            return Util.isProvider(this.paramType);
        }

        boolean isGenericType() {
            return this.genericType.isGenericType();
        }

        boolean isGenericParam() {
            return this.isGenericType() && !this.isProvider();
        }

        Dependency dependsOn() {
            return new Dependency(this.paramType, this.utilType.isCollection());
        }

        void addImports(ImportTypeMap importTypes) {
            this.fullGenericType.addImports(importTypes);
            Util.getNullableAnnotation(this.element).map(Object::toString).ifPresent(importTypes::add);
        }

        void checkRequest(BeanRequestParams requestParams) {
            this.requestParam = requestParams.check(this.paramType);
            if (this.requestParam) {
                this.requestParamName = requestParams.argumentName(this.paramType);
            }
        }

        void writeRequestDependency(Append writer) {
            if (!this.requestParam) {
                this.requestParamName = writer.nextName(Util.trimmedName(this.genericType));
                writer.append("  @Inject").eol();
                writer.append("  ");
                this.genericType.writeShort(writer);
                writer.append(" %s;", this.requestParamName).eol().eol();
            }
        }

        void writeRequestConstructor(Append writer) {
            writer.commaAppend(this.requestParamName);
        }

        void writeMethodParam(Append writer) {
            if (this.nullable) {
                writer.append("@Nullable ");
            }
            if (this.genericType.isGenericType()) {
                this.genericType.writeShort(writer);
            } else {
                writer.append(Util.shortName(this.genericType.topType()));
            }
            writer.append(" ").append(this.simpleName);
        }

        void writeMethodParamAspect(Append writer) {
            if (this.fullGenericType.isGenericType()) {
                this.fullGenericType.writeShort(writer);
            } else {
                writer.append(Util.shortName(this.fullGenericType.topType()));
            }
            writer.append(" ").append(this.simpleName);
        }

        void writeMethodParamTypeAspect(Append writer) {
            writer.append(Util.shortName(this.fullGenericType.topType()));
        }

        void writeConstructorInit(Append writer) {
            writer.append(this.simpleName);
        }

        void removeFromProvides(List<String> provides) {
            provides.remove(this.genericType.toString());
        }
    }
}

