/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.AspectImportPrism;
import io.avaje.inject.generator.ExternalProvider;
import io.avaje.inject.generator.PrimitiveUtil;
import io.avaje.inject.generator.ScopeInfo;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ProcessingContext {
    private static final ThreadLocal<Ctx> CTX = new ThreadLocal();

    private ProcessingContext() {
    }

    public static void init(ProcessingEnvironment processingEnv, Set<String> moduleFileProvided) {
        CTX.set(new Ctx(processingEnv, moduleFileProvided));
        APContext.init(processingEnv);
    }

    public static void testInit() {
        CTX.set(new Ctx());
    }

    static String loadMetaInfServices() {
        List<String> lines = ProcessingContext.loadMetaInf("META-INF/services/io.avaje.inject.spi.Module");
        return lines.isEmpty() ? null : lines.get(0);
    }

    static List<String> loadMetaInfCustom() {
        return ProcessingContext.loadMetaInf("META-INF/services/io.avaje.inject.spi.Module.Custom");
    }

    private static List<String> loadMetaInf(String fullName) {
        try {
            FileObject fileObject = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", fullName);
            if (fileObject != null) {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                Reader reader = fileObject.openReader(true);
                LineNumberReader lineReader = new LineNumberReader(reader);
                while ((line = lineReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    lines.add(line);
                }
                return lines;
            }
        }
        catch (FileNotFoundException | NoSuchFileException fileObject) {
        }
        catch (FilerException e) {
            APContext.logNote("FilerException reading services file", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            APContext.logWarn("Error reading services file: " + e.getMessage(), new Object[0]);
        }
        return Collections.emptyList();
    }

    static FileObject createMetaInfWriter(ScopeInfo.Type scopeType) throws IOException {
        String serviceName = scopeType == ScopeInfo.Type.DEFAULT ? "META-INF/services/io.avaje.inject.spi.Module" : "META-INF/services/io.avaje.inject.test.TestModule";
        return ProcessingContext.createMetaInfWriterFor(serviceName);
    }

    private static FileObject createMetaInfWriterFor(String interfaceType) throws IOException {
        return APContext.filer().createResource(StandardLocation.CLASS_OUTPUT, "", interfaceType, new Element[0]);
    }

    static TypeElement elementMaybe(String rawType) {
        if (rawType == null) {
            return null;
        }
        return APContext.elements().getTypeElement(rawType);
    }

    static TypeElement asElement(TypeMirror returnType) {
        String wrapper = PrimitiveUtil.wrap(returnType.toString());
        return wrapper == null ? APContext.asTypeElement(returnType) : APContext.typeElement(wrapper);
    }

    static boolean isUncheckedException(TypeMirror returnType) {
        TypeMirror runtime = APContext.typeElement("java.lang.RuntimeException").asType();
        return APContext.types().isSubtype(returnType, runtime);
    }

    static void addModule(String moduleFullName) {
        if (moduleFullName != null) {
            ProcessingContext.CTX.get().uniqueModuleNames.add(moduleFullName);
        }
    }

    static boolean isDuplicateModule(String moduleFullName) {
        return ProcessingContext.CTX.get().uniqueModuleNames.contains(moduleFullName);
    }

    static boolean externallyProvided(String type) {
        return ProcessingContext.CTX.get().providedTypes.contains(type) || ProcessingContext.CTX.get().optionalTypes.contains(type);
    }

    static void addOptionalType(String paramType) {
        if (!ProcessingContext.CTX.get().providedTypes.contains(paramType)) {
            ProcessingContext.CTX.get().optionalTypes.add(paramType);
        }
    }

    static void addImportedAspects(Map<String, AspectImportPrism> importedMap) {
        ProcessingContext.CTX.get().aspectImportPrisms.putAll(importedMap);
    }

    static void validateModule(String injectFQN) {
        ModuleElement module = APContext.getProjectModuleElement();
        if (module != null && !ProcessingContext.CTX.get().validated && !module.isUnnamed()) {
            ProcessingContext.CTX.get().validated = true;
            try (BufferedReader reader = APContext.getModuleInfoReader();){
                boolean noProvides = reader.lines().noneMatch(s -> s.contains(injectFQN));
                if (noProvides) {
                    APContext.logError(module, "Missing \"provides io.avaje.inject.spi.Module with %s;\"", injectFQN);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static Optional<AspectImportPrism> getImportedAspect(String type) {
        return Optional.ofNullable(ProcessingContext.CTX.get().aspectImportPrisms.get(type));
    }

    public static void clear() {
        CTX.remove();
        APContext.clear();
    }

    static final class Ctx {
        private final Set<String> uniqueModuleNames = new HashSet<String>();
        private final Set<String> providedTypes = new HashSet<String>();
        private final Set<String> optionalTypes = new LinkedHashSet<String>();
        private final Map<String, AspectImportPrism> aspectImportPrisms = new HashMap<String, AspectImportPrism>();
        private boolean validated;

        public Ctx(ProcessingEnvironment processingEnv, Set<String> moduleFileProvided) {
            ExternalProvider.registerModuleProvidedTypes(this.providedTypes);
            this.providedTypes.addAll(moduleFileProvided);
        }

        public Ctx() {
        }
    }
}

