/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.AllScopes;
import io.avaje.inject.generator.AspectImportPrism;
import io.avaje.inject.generator.ExternalProvider;
import io.avaje.inject.generator.ImportPrism;
import io.avaje.inject.generator.InjectModulePrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.ScopePrism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.avaje.inject.InjectModule", "io.avaje.inject.Factory", "jakarta.inject.Singleton", "io.avaje.inject.Component", "io.avaje.inject.Prototype", "jakarta.inject.Scope", "io.avaje.inject.test.TestScope", "io.avaje.http.api.Controller", "io.avaje.inject.Component.Import", "io.avaje.inject.aop.Aspect.Import"})
public final class Processor
extends AbstractProcessor {
    private Elements elementUtils;
    private ScopeInfo defaultScope;
    private AllScopes allScopes;
    private boolean readModuleInfo;
    private final Set<String> pluginFileProvided = new HashSet<String>();
    private final Set<String> moduleFileProvided = new HashSet<String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.loadProvidedFiles(processingEnv.getFiler());
        ProcessingContext.init(processingEnv, this.moduleFileProvided);
        this.elementUtils = processingEnv.getElementUtils();
        this.allScopes = new AllScopes();
        this.defaultScope = this.allScopes.defaultScope();
        ExternalProvider.registerPluginProvidedTypes(this.defaultScope);
        this.pluginFileProvided.forEach(this.defaultScope::pluginProvided);
    }

    void loadProvidedFiles(Filer filer) {
        this.pluginFileProvided.addAll(Processor.lines(filer, "target/avaje-plugin-provides.txt", "/target/classes"));
        this.moduleFileProvided.addAll(Processor.lines(filer, "target/avaje-module-provides.txt", "/target/classes"));
        this.pluginFileProvided.addAll(Processor.lines(filer, "build/avaje-plugin-provides.txt", "/build/classes/java/main"));
        this.moduleFileProvided.addAll(Processor.lines(filer, "build/avaje-module-provides.txt", "/build/classes/java/main"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<String> lines(Filer filer, String relativeName, String replace) {
        try {
            String resource = Processor.resource(filer, relativeName, replace);
            try (InputStream inputStream = new URI(resource).toURL().openStream();){
                List<String> list;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                    list = reader.lines().collect(Collectors.toList());
                }
                return list;
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private static String resource(Filer filer, String relativeName, String replace) throws IOException {
        return filer.getResource(StandardLocation.CLASS_OUTPUT, "", relativeName).toUri().toString().replace(replace, "");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        APContext.setProjectModuleElement(annotations, roundEnv);
        this.readModule(roundEnv);
        ProcessingContext.addImportedAspects(Processor.importedAspects(roundEnv));
        Processor.maybeElements(roundEnv, "jakarta.inject.Scope").ifPresent(this::readScopes);
        Processor.maybeElements(roundEnv, "io.avaje.inject.Factory").ifPresent(this::readFactories);
        if (this.defaultScope.includeSingleton()) {
            Processor.maybeElements(roundEnv, "jakarta.inject.Singleton").ifPresent(this::readBeans);
        }
        Processor.maybeElements(roundEnv, "io.avaje.inject.Component").ifPresent(this::readBeans);
        Processor.maybeElements(roundEnv, "io.avaje.inject.Prototype").ifPresent(this::readBeans);
        this.readImported(this.importedElements(roundEnv));
        Processor.maybeElements(roundEnv, "io.avaje.http.api.Controller").ifPresent(this::readBeans);
        Processor.maybeElements(roundEnv, "io.avaje.inject.spi.Proxy").ifPresent(this::readBeans);
        this.allScopes.readBeans(roundEnv);
        this.defaultScope.write(roundEnv.processingOver());
        this.allScopes.write(roundEnv.processingOver());
        if (roundEnv.processingOver()) {
            ProcessingContext.clear();
        }
        return false;
    }

    private static Optional<? extends Set<? extends Element>> maybeElements(RoundEnvironment round, String name) {
        return Optional.ofNullable(APContext.typeElement(name)).map(round::getElementsAnnotatedWith);
    }

    private Set<TypeElement> importedElements(RoundEnvironment roundEnv) {
        return Processor.maybeElements(roundEnv, "io.avaje.inject.Component.Import").stream().flatMap(Collection::stream).map(ImportPrism::getInstanceOn).flatMap(p -> p.value().stream()).map(ProcessingContext::asElement).filter(this::notAlreadyProvided).collect(Collectors.toSet());
    }

    private boolean notAlreadyProvided(TypeElement e) {
        String type = e.getQualifiedName().toString();
        return !this.moduleFileProvided.contains(type) && !this.pluginFileProvided.contains(type);
    }

    private static Map<String, AspectImportPrism> importedAspects(RoundEnvironment roundEnv) {
        return Processor.maybeElements(roundEnv, "io.avaje.inject.aop.Aspect.Import").stream().flatMap(Collection::stream).map(AspectImportPrism::getInstanceOn).collect(Collectors.toMap(p -> p.value().toString(), p -> p));
    }

    private void readScopes(Set<? extends Element> scopes) {
        for (Element element : scopes) {
            if (element.getKind() != ElementKind.ANNOTATION_TYPE || !(element instanceof TypeElement)) continue;
            TypeElement type = (TypeElement)element;
            this.allScopes.addScopeAnnotation(type);
        }
        this.addTestScope();
    }

    private void addTestScope() {
        TypeElement testScopeType = this.elementUtils.getTypeElement("io.avaje.inject.test.TestScope");
        if (testScopeType != null) {
            this.allScopes.addScopeAnnotation(testScopeType);
        }
    }

    private void readFactories(Set<? extends Element> beans) {
        this.readChangedBeans(ElementFilter.typesIn(beans), true, false);
    }

    private void readBeans(Set<? extends Element> beans) {
        this.readChangedBeans(ElementFilter.typesIn(beans), false, false);
    }

    private void readImported(Set<? extends Element> beans) {
        this.readChangedBeans(ElementFilter.typesIn(beans), false, true);
    }

    private void readChangedBeans(Set<TypeElement> beans, boolean factory, boolean importedComponent) {
        for (TypeElement typeElement : beans) {
            if (typeElement.getKind() == ElementKind.INTERFACE) continue;
            ScopeInfo scope = this.findScope(typeElement);
            if (!factory) {
                if (scope != null) continue;
                this.defaultScope.read(typeElement, false, importedComponent);
                continue;
            }
            if (scope != null) {
                scope.read(typeElement, true, false);
                continue;
            }
            this.defaultScope.read(typeElement, true, false);
        }
    }

    private ScopeInfo findScope(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            ScopeInfo scopeInfo = this.allScopes.get(annotationMirror.getAnnotationType().toString());
            if (scopeInfo == null) continue;
            return scopeInfo;
        }
        return null;
    }

    private void readModule(RoundEnvironment roundEnv) {
        TypeElement moduleType;
        if (this.readModuleInfo) {
            return;
        }
        this.readModuleInfo = true;
        String factory = ProcessingContext.loadMetaInfServices();
        if (factory != null && (moduleType = this.elementUtils.getTypeElement(factory)) != null) {
            this.defaultScope.readModuleMetaData(moduleType);
        }
        this.allScopes.readModules(ProcessingContext.loadMetaInfCustom());
        this.readInjectModule(roundEnv);
    }

    private void readInjectModule(RoundEnvironment roundEnv) {
        Processor.maybeElements(roundEnv, "io.avaje.inject.InjectModule").stream().flatMap(Collection::stream).forEach(element -> {
            InjectModulePrism annotation;
            ScopePrism scope = ScopePrism.getInstanceOn(element);
            if (scope == null && (annotation = InjectModulePrism.getInstanceOn(element)) != null) {
                this.defaultScope.details(annotation.name(), (Element)element);
            }
        });
    }
}

