/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;

final class SimpleBeanWriter {
    private static final String CODE_COMMENT = "/**\n * Generated source - dependency injection builder for %s.\n */";
    private static final String CODE_COMMENT_FACTORY = "/**\n * Generated source - dependency injection factory for request scoped %s.\n */";
    private static final String CODE_COMMENT_BUILD = "  /**\n   * Create and register %s.\n   */";
    private static final String CODE_COMMENT_BUILD_PROVIDER = "  /**\n   * Register %s provider.\n   */";
    private final BeanReader beanReader;
    private final String originName;
    private final String shortName;
    private final String packageName;
    private final String suffix;
    private final boolean proxied;
    private Append writer;
    private String indent = "     ";

    SimpleBeanWriter(BeanReader beanReader) {
        this.beanReader = beanReader;
        this.packageName = beanReader.packageName();
        this.shortName = beanReader.shortName();
        this.suffix = beanReader.suffix();
        this.proxied = beanReader.isGenerateProxy();
        this.originName = this.packageName + "." + this.shortName;
    }

    private Writer createFileWriter() throws IOException {
        String originName = this.originName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            originName = originName.replace(this.shortName, this.shortName.replace(".", "$"));
        }
        JavaFileObject jfo = APContext.createSourceFile(originName + this.suffix, new Element[0]);
        return jfo.openWriter();
    }

    void write() throws IOException {
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClassStart();
        if (this.isRequestScopedController()) {
            this.writeRequestCreate();
        } else {
            this.writeGenericTypeFields();
            this.writeStaticFactoryMethod();
            this.writeStaticFactoryBeanMethods();
        }
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeGenericTypeFields() {
        Set<GenericType> genericTypes = this.beanReader.allGenericTypes();
        if (!genericTypes.isEmpty()) {
            HashMap<String, String> seenShortNames = new HashMap<String, String>();
            for (GenericType type : genericTypes) {
                this.writer.append("  public static final Type TYPE_%s =", type.shortName().replace(".", "_")).eol().append("      new GenericType<");
                this.writeGenericType(type, seenShortNames, this.writer);
                this.writer.append(">(){}.type();").eol();
            }
            this.writer.eol();
        }
    }

    private void writeGenericType(GenericType type, Map<String, String> seenShortNames, Append writer) {
        String typeShortName = Util.shortName(type.topType());
        String topType = seenShortNames.computeIfAbsent(typeShortName, k -> type.topType());
        if (type.isGenericType()) {
            String shortName = Objects.equals(type.topType(), topType) ? typeShortName : type.topType();
            writer.append(shortName);
            writer.append("<");
            boolean first = true;
            for (GenericType param : type.params()) {
                if (first) {
                    first = false;
                    this.writeGenericType(param, seenShortNames, writer);
                    continue;
                }
                writer.append(", ");
                this.writeGenericType(param, seenShortNames, writer);
            }
            writer.append(">");
        } else {
            String shortName = Objects.equals(type.topType(), topType) ? typeShortName : type.topType();
            writer.append(shortName);
        }
    }

    private void writeRequestCreate() {
        this.beanReader.writeRequestCreate(this.writer);
    }

    private boolean isRequestScopedController() {
        return this.beanReader.isRequestScopedController();
    }

    private void writeStaticFactoryBeanMethods() {
        for (MethodReader factoryMethod : this.beanReader.factoryMethods()) {
            this.writeFactoryBeanMethod(factoryMethod);
        }
    }

    private void writeFactoryBeanMethod(MethodReader method) {
        method.commentBuildMethod(this.writer);
        this.writer.append("  public static void build_%s(%s builder) {", method.name(), this.beanReader.builderType()).eol();
        method.buildConditional(this.writer);
        method.buildAddFor(this.writer);
        method.builderGetFactory(this.writer, this.beanReader.hasConditions());
        method.startTry(this.writer);
        if (method.isProtoType() || method.isUseProviderForSecondary()) {
            method.builderAddBeanProvider(this.writer);
            method.endTry(this.writer);
        } else {
            method.builderBuildBean(this.writer);
            method.builderBuildAddBean(this.writer);
            method.endTry(this.writer);
            this.writer.append("    }").eol();
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeStaticFactoryMethod() {
        MethodReader constructor = this.beanReader.constructor();
        if (constructor == null) {
            APContext.logError(this.beanReader.beanType(), "Unable to determine constructor to use for %s? Add explicit @Inject to one of the constructors.", this.beanReader.beanType());
            return;
        }
        this.writeBuildMethodStart();
        if (this.proxied) {
            this.writer.append("    // this bean is proxied, see %s$Proxy$DI instead", this.shortName).eol();
        } else {
            this.writeAddFor(constructor);
        }
        this.writer.append("  }").eol().eol();
    }

    private void writeAddFor(MethodReader constructor) {
        this.beanReader.buildConditional(this.writer);
        this.beanReader.buildAddFor(this.writer);
        if (this.beanReader.prototype()) {
            this.indent = this.indent + "  ";
            this.writer.append("      builder.asPrototype().registerProvider(() -> {", this.shortName, this.shortName).eol();
        }
        constructor.startTry(this.writer);
        this.writeCreateBean(constructor);
        this.beanReader.buildRegister(this.writer);
        this.beanReader.addLifecycleCallbacks(this.writer, this.indent);
        if (this.beanReader.isExtraInjectionRequired()) {
            this.writeExtraInjection();
        }
        if (this.beanReader.prototype()) {
            this.beanReader.prototypePostConstruct(this.writer, this.indent);
            this.writer.indent("        return bean;").eol();
            this.writer.indent("      });").eol();
        }
        constructor.endTry(this.writer);
        this.writer.append("    }").eol();
    }

    private void writeBuildMethodStart() {
        if (this.beanReader.prototype()) {
            this.writer.append(CODE_COMMENT_BUILD_PROVIDER, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT_BUILD, this.shortName).eol();
        }
        this.writer.append("  public static void build(%s builder) {", this.beanReader.builderType()).eol();
    }

    private void writeCreateBean(MethodReader constructor) {
        this.writer.indent(this.indent).append(" var bean = new %s(", this.shortName);
        this.writeMethodParams("builder", constructor);
    }

    private void writeExtraInjection() {
        if (!this.beanReader.prototype()) {
            this.writer.indent("      ").append("builder.addInjector(b -> {").eol();
            this.writer.indent("      ").append("  // field and method injection").eol();
        }
        this.injectFields();
        this.injectMethods();
        if (!this.beanReader.prototype()) {
            this.writer.indent("      });").eol();
        }
    }

    private void injectFields() {
        String bean = this.beanReader.prototype() ? "bean" : "$bean";
        String builder = this.beanReader.prototype() ? "builder" : "b";
        for (FieldReader fieldReader : this.beanReader.injectFields()) {
            String fieldName = fieldReader.fieldName();
            String getDependency = fieldReader.builderGetDependency(builder);
            this.writer.indent("        ").append("%s.%s = %s;", bean, fieldName, getDependency).eol();
        }
    }

    private void injectMethods() {
        String builder;
        boolean needsTry = this.beanReader.needsTryForMethodInjection();
        String bean = this.beanReader.prototype() ? "bean" : "$bean";
        String string = builder = this.beanReader.prototype() ? "builder" : "b";
        if (needsTry) {
            this.writer.indent("        try {").eol();
        }
        String indent = needsTry ? "          " : "        ";
        for (MethodReader methodReader : this.beanReader.injectMethods()) {
            this.writer.indent(indent).append("%s.%s(", bean, methodReader.name());
            this.writeMethodParams(builder, methodReader);
        }
        if (needsTry) {
            this.writer.indent("        } catch (Throwable e) {").eol();
            this.writer.indent("          throw new RuntimeException(\"Error wiring method\", e);").eol();
            this.writer.indent("        }").eol();
        }
    }

    private void writeMethodParams(String builderRef, MethodReader methodReader) {
        List<MethodReader.MethodParam> methodParams = methodReader.params();
        for (int i = 0; i < methodParams.size(); ++i) {
            if (i > 0) {
                this.writer.append(", ");
            }
            methodParams.get(i).builderGetDependency(this.writer, builderRef);
        }
        this.writer.append(");").eol();
    }

    private void writeImports() {
        this.beanReader.writeImports(this.writer);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeClassStart() {
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append(CODE_COMMENT_FACTORY, this.shortName).eol();
        } else {
            this.writer.append(CODE_COMMENT, this.shortName).eol();
        }
        this.writer.append(this.beanReader.generatedType()).append("(\"io.avaje.inject.generator\")").eol();
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append("@Singleton").eol();
        }
        String shortName = this.shortName;
        if (this.beanReader.beanType().getNestingKind().isNested()) {
            shortName = shortName.replace(".", "$");
        }
        this.writer.append("public final class ").append(shortName).append(this.suffix).append(" ");
        if (this.beanReader.isRequestScopedController()) {
            this.writer.append("implements ");
            this.beanReader.factoryInterface(this.writer);
        }
        this.writer.append(" {").eol().eol();
    }

    private void writePackage() {
        if (this.packageName != null) {
            this.writer.append("package %s;", this.packageName).eol().eol();
        }
    }
}

