/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.ImportTypeMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class TypeAppender {
    private final ImportTypeMap importTypes;
    private final Set<String> types = new LinkedHashSet<String>();
    private final Set<GenericType> genericTypes = new LinkedHashSet<GenericType>();

    TypeAppender(ImportTypeMap importTypes) {
        this.importTypes = importTypes;
    }

    void add(GenericType type) {
        if (type.isGenericType()) {
            this.addGenericType(type);
        } else {
            this.addSimpleType(type.topType());
        }
    }

    void add(List<String> sourceTypes) {
        for (String type : sourceTypes) {
            GenericType genericType = GenericType.parse(type);
            if (genericType.isGenericType()) {
                this.addGenericType(genericType);
                continue;
            }
            this.addSimpleType(genericType.topType());
        }
    }

    void addSimpleType(String classType) {
        String shortName = this.importTypes.add(classType);
        this.types.add(shortName + ".class");
    }

    private void addGenericType(GenericType genericType) {
        this.genericTypes.add(genericType);
        this.types.add("TYPE_" + genericType.shortName().replace(".", "_"));
    }

    Set<GenericType> genericTypes() {
        return this.genericTypes;
    }

    String asString() {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (String type : this.types) {
            if (count++ > 0) {
                sb.append(", ");
            }
            sb.append(type);
        }
        return sb.toString();
    }
}

