/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.FactoryPrism;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GeneratedPrism;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.TypeExtendsInjection;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class TypeExtendsReader {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String JAVA_LANG_RECORD = "java.lang.Record";
    private final GenericType baseGenericType;
    private final TypeElement baseType;
    private final TypeExtendsInjection extendsInjection;
    private final List<String> extendsTypes = new ArrayList<String>();
    private final List<String> interfaceTypes = new ArrayList<String>();
    private final List<String> providesTypes = new ArrayList<String>();
    private final String beanSimpleName;
    private final String baseTypeRaw;
    private final boolean baseTypeIsInterface;
    private final boolean publicAccess;
    private final boolean autoProvide;
    private final boolean proxyBean;
    private boolean closeable;
    private String qualifierName;
    private String providesAspect = "";

    TypeExtendsReader(GenericType baseGenericType, TypeElement baseType, boolean factory, ImportTypeMap importTypes, boolean proxyBean) {
        this.baseGenericType = baseGenericType;
        this.baseType = baseType;
        this.extendsInjection = new TypeExtendsInjection(baseType, factory, importTypes);
        this.beanSimpleName = baseType.getSimpleName().toString();
        this.baseTypeRaw = Util.unwrapProvider(baseGenericType.toString());
        this.baseTypeIsInterface = baseType.getKind() == ElementKind.INTERFACE;
        this.publicAccess = baseType.getModifiers().contains((Object)Modifier.PUBLIC);
        this.autoProvide = this.autoProvide();
        this.proxyBean = proxyBean;
    }

    private boolean autoProvide() {
        return this.publicAccess && !FactoryPrism.isPresent(this.baseType) && !ProxyPrism.isPresent(this.baseType) && !GeneratedPrism.isPresent(this.baseType) && !this.isController();
    }

    private boolean isController() {
        try {
            return this.baseType.getAnnotation(Class.forName("io.avaje.http.api.Controller")) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    GenericType baseType() {
        return this.baseGenericType;
    }

    String qualifierName() {
        return this.qualifierName;
    }

    BeanAspects hasAspects() {
        return this.extendsInjection.hasAspects();
    }

    List<FieldReader> injectFields() {
        return this.extendsInjection.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.extendsInjection.injectMethods();
    }

    List<MethodReader> factoryMethods() {
        return this.extendsInjection.factoryMethods();
    }

    Element postConstructMethod() {
        return this.extendsInjection.postConstructMethod();
    }

    Element preDestroyMethod() {
        return this.extendsInjection.preDestroyMethod();
    }

    Integer preDestroyPriority() {
        return this.extendsInjection.preDestroyPriority();
    }

    MethodReader constructor() {
        return this.extendsInjection.constructor();
    }

    String providesAspect() {
        return this.providesAspect;
    }

    String autoProvides() {
        if (!this.autoProvide || !this.providesAspect.isEmpty()) {
            return null;
        }
        if (this.baseTypeIsInterface || this.interfaceTypes.isEmpty()) {
            return this.baseTypeRaw;
        }
        return this.interfaceTypes.get(0);
    }

    List<String> provides() {
        return this.providesTypes;
    }

    boolean isCloseable() {
        return this.closeable;
    }

    void process(boolean forBean) {
        this.extendsTypes.add(this.baseTypeRaw);
        if (forBean) {
            this.extendsInjection.read(this.baseType);
        }
        this.readInterfaces(this.baseType);
        TypeMirror superMirror = this.baseType.getSuperclass();
        TypeElement superElement = ProcessingContext.asElement(superMirror);
        if (superElement != null) {
            String superName;
            String baseName;
            if (this.qualifierName == null && (baseName = this.baseType.getSimpleName().toString()).endsWith(superName = superElement.getSimpleName().toString())) {
                this.qualifierName = baseName.substring(0, baseName.length() - superName.length()).toLowerCase();
            }
            this.addSuperType(superElement, superMirror, this.proxyBean);
        }
        this.providesTypes.addAll(this.extendsTypes);
        this.providesTypes.addAll(this.interfaceTypes);
        this.providesTypes.remove(this.baseTypeRaw);
        this.extendsInjection.removeFromProvides(this.providesTypes);
        this.providesAspect = this.initProvidesAspect();
    }

    private String initProvidesAspect() {
        for (String providesType : this.providesTypes) {
            if (!Util.isAspectProvider(providesType)) continue;
            return Util.extractAspectType(providesType);
        }
        return "";
    }

    private void addSuperType(TypeElement element, TypeMirror mirror, boolean proxyBean) {
        this.readInterfaces(element);
        String fullName = mirror.toString();
        if (!JAVA_LANG_OBJECT.equals(fullName) && !JAVA_LANG_RECORD.equals(fullName)) {
            String type = Util.unwrapProvider(fullName);
            if (proxyBean || this.isPublic(element)) {
                GenericType genericType = GenericType.parse(type);
                boolean knownType = genericType.params().stream().flatMap(g -> Stream.concat(Stream.of(g), g.params().stream())).noneMatch(g -> APContext.typeElement(g.mainType()) == null);
                this.extendsTypes.add(knownType ? type : genericType.topType());
                this.extendsInjection.read(element);
            }
            TypeMirror superMirror = element.getSuperclass();
            TypeElement superElement = ProcessingContext.asElement(superMirror);
            this.addSuperType(superElement, superMirror, false);
        }
    }

    private void readInterfaces(TypeElement type) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            if (!this.isPublic(ProcessingContext.asElement(typeMirror))) continue;
            this.readInterfacesOf(typeMirror);
        }
    }

    private void readInterfacesOf(TypeMirror anInterface) {
        String rawType = Util.unwrapProvider(anInterface.toString());
        if (JAVA_LANG_OBJECT.equals(rawType)) {
            return;
        }
        if (rawType.indexOf(46) == -1) {
            APContext.logWarn("skip when no package on interface " + rawType, new Object[0]);
        } else if ("java.lang.AutoCloseable".equals(rawType) || "java.io.Closeable".equals(rawType)) {
            this.closeable = true;
        } else {
            boolean knownType;
            String mainType;
            String iShortName;
            GenericType genericType = GenericType.parse(rawType);
            if (this.qualifierName == null && this.beanSimpleName.endsWith(iShortName = Util.shortName(mainType = genericType.topType()))) {
                this.qualifierName = this.beanSimpleName.substring(0, this.beanSimpleName.length() - iShortName.length()).toLowerCase();
            }
            this.interfaceTypes.add((knownType = genericType.params().stream().flatMap(g -> Stream.concat(Stream.of(g), g.params().stream())).noneMatch(g -> APContext.typeElement(g.mainType()) == null)) ? rawType : GenericType.removeParameter(rawType));
            if (!rawType.startsWith("java.lang.")) {
                for (TypeMirror typeMirror : APContext.types().directSupertypes(anInterface)) {
                    this.readInterfacesOf(typeMirror);
                }
            }
        }
    }

    private boolean isPublic(Element element) {
        return element != null && element.getModifiers().contains((Object)Modifier.PUBLIC);
    }
}

