/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.BeanConditions;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.ConditionalWriter;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.FactoryPrism;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.LazyPrism;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.PrimaryPrism;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.PrototypePrism;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.SecondaryPrism;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

final class BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final String name;
    private final MethodReader constructor;
    private final List<FieldReader> injectFields;
    private final List<MethodReader> injectMethods;
    private final List<MethodReader> factoryMethods;
    private final Element postConstructMethod;
    private final Element preDestroyMethod;
    private final ImportTypeMap importTypes = new ImportTypeMap();
    private final BeanRequestParams requestParams;
    private final TypeReader typeReader;
    private final boolean prototype;
    private final boolean primary;
    private final boolean secondary;
    private final boolean lazy;
    private final boolean proxy;
    private final BeanAspects aspects;
    private final BeanConditions conditions = new BeanConditions();
    private final boolean importedComponent;
    private final Integer preDestroyPriority;
    private boolean writtenToFile;
    private boolean suppressBuilderImport;
    private boolean suppressGeneratedImport;
    private Set<UType> allUTypes;
    private final boolean delayed;

    BeanReader(TypeElement beanType, boolean factory, boolean importedComponent) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        this.prototype = PrototypePrism.isPresent(beanType);
        this.primary = PrimaryPrism.isPresent(beanType);
        this.secondary = !this.primary && SecondaryPrism.isPresent(beanType);
        this.lazy = !FactoryPrism.isPresent(beanType) && LazyPrism.isPresent(beanType);
        this.typeReader = new TypeReader(UType.parse(beanType.asType()), beanType, this.importTypes, factory);
        this.typeReader.process();
        this.requestParams = new BeanRequestParams(this.type);
        this.name = this.typeReader.name();
        this.aspects = this.typeReader.hasAspects();
        this.injectMethods = this.typeReader.injectMethods();
        this.injectFields = this.typeReader.injectFields();
        this.factoryMethods = this.typeReader.factoryMethods();
        this.postConstructMethod = this.typeReader.postConstructMethod();
        this.preDestroyMethod = this.typeReader.preDestroyMethod();
        this.preDestroyPriority = this.typeReader.preDestroyPriority();
        this.constructor = this.typeReader.constructor();
        boolean bl = this.importedComponent = importedComponent && this.constructor != null && this.constructor.isPublic();
        if (ProxyPrism.isPresent(beanType)) {
            this.proxy = true;
            this.conditions.readAll(APContext.asTypeElement(beanType.getSuperclass()));
        } else {
            this.conditions.readAll(beanType);
            this.proxy = false;
        }
        this.delayed = this.shouldDelay();
    }

    private boolean shouldDelay() {
        Stream<Element> construct = Optional.ofNullable(this.constructor).map(MethodReader::params).stream().flatMap(Collection::stream).map(MethodReader.MethodParam::element);
        Stream<Element> fields = this.injectFields.stream().map(FieldReader::element);
        Stream<Element> constructFields = Stream.concat(construct, fields);
        Stream<Element> methods = this.injectMethods.stream().map(MethodReader::params).flatMap(Collection::stream).map(MethodReader.MethodParam::element);
        return Stream.concat(constructFields, methods).map(Element::asType).anyMatch(t -> t.getKind() == TypeKind.ERROR);
    }

    public String toString() {
        return this.beanType.toString();
    }

    TypeElement beanType() {
        return this.beanType;
    }

    BeanAspects aspects() {
        return this.aspects;
    }

    boolean registerProvider() {
        return this.prototype || this.lazy;
    }

    boolean lazy() {
        return this.lazy;
    }

    boolean importedComponent() {
        return this.importedComponent;
    }

    BeanReader read() {
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
            this.constructor.checkRequest(this.requestParams);
        }
        for (FieldReader field : this.injectFields) {
            field.addImports(this.importTypes);
            field.checkRequest(this.requestParams);
        }
        for (MethodReader method : this.injectMethods) {
            method.addImports(this.importTypes);
            method.checkRequest(this.requestParams);
        }
        for (MethodReader factoryMethod : this.factoryMethods) {
            factoryMethod.addImports(this.importTypes);
        }
        this.conditions.addImports(this.importTypes);
        return this;
    }

    List<Dependency> dependsOn() {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param : this.constructor.params()) {
                Dependency dependsOn = param.dependsOn();
                if ("io.avaje.inject.BeanScope".equals(dependsOn.dependsOn())) continue;
                list.add(dependsOn);
            }
        }
        this.conditions.requireTypes.stream().map(t -> new Dependency("con:" + t)).forEach(list::add);
        this.conditions.missingTypes.stream().filter(t -> !t.equals(this.type)).map(t -> new Dependency("con:" + t)).forEach(list::add);
        return list;
    }

    List<MethodReader> factoryMethods() {
        return this.factoryMethods;
    }

    List<String> provides() {
        return this.typeReader.provides();
    }

    List<String> autoProvides() {
        return this.typeReader.autoProvides();
    }

    String providesAspect() {
        return this.typeReader.providesAspect();
    }

    Set<UType> allGenericTypes() {
        if (this.allUTypes != null) {
            return this.allUTypes;
        }
        this.allUTypes = new LinkedHashSet<UType>(this.typeReader.genericTypes());
        for (FieldReader field : this.injectFields) {
            field.addDependsOnGeneric(this.allUTypes);
        }
        for (MethodReader method : this.injectMethods) {
            method.addDependsOnGeneric(this.allUTypes);
        }
        if (this.constructor != null) {
            this.constructor.addDependsOnGeneric(this.allUTypes);
        }
        for (MethodReader factoryMethod : this.factoryMethods()) {
            factoryMethod.addDependsOnGeneric(this.allUTypes);
        }
        return this.allUTypes;
    }

    private String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    String metaKey() {
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean hasLifecycleMethods() {
        return this.postConstructMethod != null || this.preDestroyMethod != null || this.typeReader.isClosable();
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        Object type = this.beanType.getNestingKind().isNested() ? this.beanType.getEnclosingElement().toString() + "$" + String.valueOf(this.beanType.getSimpleName()) : this.beanQualifiedName();
        MetaData metaData = new MetaData((String)type, this.name);
        metaData.update(this);
        return metaData;
    }

    boolean isExtraInjectionRequired() {
        return !this.injectFields.isEmpty() || !this.injectMethods.isEmpty();
    }

    void buildConditional(Append writer) {
        new ConditionalWriter(writer, this.conditions).write();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.name != null && !this.name.isEmpty()) {
            writer.append("\"%s\", ", this.name);
        }
        writer.append(this.typeReader.typesRegister());
        writer.append(")) {").eol();
    }

    void buildRegister(Append writer) {
        if (this.prototype || this.lazy) {
            return;
        }
        writer.indent("      ");
        if (this.isExtraInjectionRequired() || this.hasLifecycleMethods()) {
            writer.append("var $bean = ");
        }
        writer.append("builder.");
        if (this.primary) {
            writer.append("asPrimary().");
        } else if (this.secondary) {
            writer.append("asSecondary().");
        }
        writer.append("register(bean);").eol();
    }

    void addLifecycleCallbacks(Append writer, String indent) {
        if (this.postConstructMethod != null && !this.registerProvider()) {
            writer.indent(indent).append(" builder.addPostConstruct($bean::%s);", this.postConstructMethod.getSimpleName()).eol();
        }
        if (this.preDestroyMethod != null) {
            this.lifeCycleNotSupported("@PreDestroy");
            String priority = this.preDestroyPriority == null || this.preDestroyPriority == 1000 ? "" : ", " + this.preDestroyPriority;
            writer.indent(indent).append(" builder.addPreDestroy($bean::%s%s);", this.preDestroyMethod.getSimpleName(), priority).eol();
        } else if (this.typeReader.isClosable() && !this.prototype) {
            writer.indent(indent).append(" builder.addPreDestroy($bean);").eol();
        }
    }

    void prototypePostConstruct(Append writer, String indent) {
        if (this.postConstructMethod != null) {
            ExecutableElement postConstruct = (ExecutableElement)this.postConstructMethod;
            writer.append("%s bean.%s(", indent, this.postConstructMethod.getSimpleName());
            if (postConstruct.getParameters().isEmpty()) {
                writer.append(");").eol();
            } else {
                writer.append("builder.get(io.avaje.inject.BeanScope.class));").eol();
            }
            writer.eol();
        }
    }

    private void lifeCycleNotSupported(String lifecycle) {
        if (this.registerProvider()) {
            APContext.logError(this.beanType, "%s scoped bean does not support the %s lifecycle method", this.prototype ? "@Prototype" : "@Lazy", lifecycle);
        }
    }

    private Set<String> importTypes() {
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        this.typeReader.extraImports(this.importTypes);
        this.requestParams.addImports(this.importTypes);
        this.aspects.extraImports(this.importTypes);
        for (MethodReader factoryMethod : this.factoryMethods) {
            Set<UType> utypes = factoryMethod.genericTypes();
            if (utypes.isEmpty()) continue;
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
            utypes.forEach(t -> this.importTypes.addAll(t.importTypes()));
        }
        this.checkImports();
        if (!this.suppressGeneratedImport) {
            this.importTypes.add("io.avaje.inject.spi.Generated");
        }
        if (!this.suppressBuilderImport) {
            this.importTypes.add("io.avaje.inject.spi.Builder");
        }
        return this.importTypes.forImport();
    }

    private void checkImports() {
        this.suppressBuilderImport = this.importTypes.containsShortName("Builder");
        this.suppressGeneratedImport = this.importTypes.containsShortName("Generated");
    }

    String builderType() {
        return this.suppressBuilderImport ? "io.avaje.inject.spi.Builder" : "Builder";
    }

    String generatedType() {
        return this.suppressGeneratedImport ? "@io.avaje.inject.spi.Generated" : "@Generated";
    }

    void writeImports(Append writer) {
        if (!this.allGenericTypes().isEmpty()) {
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
        }
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", Util.sanitizeImports(importType)).eol();
        }
        writer.eol();
    }

    MethodReader constructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    boolean isRequestScopedController() {
        return this.requestParams.isRequestScopedController();
    }

    String suffix() {
        return this.isRequestScopedController() ? "$Factory" : "$DI";
    }

    void factoryInterface(Append writer) {
        this.requestParams.factoryInterface(writer);
    }

    void writeRequestCreate(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeRequestDependency(writer);
        }
        for (FieldReader field : this.injectFields) {
            field.writeRequestDependency(writer);
        }
        for (MethodReader method : this.injectMethods) {
            method.writeRequestDependency(writer);
        }
        this.requestParams.writeRequestCreate(writer);
        writer.resetNextName();
        writer.append("    var bean = new %s(", this.shortName);
        if (this.constructor != null) {
            this.constructor.writeRequestConstructor(writer);
        }
        writer.append(");").eol();
        for (FieldReader field : this.injectFields) {
            field.writeRequestInject(writer);
        }
        for (MethodReader method : this.injectMethods) {
            writer.append("    bean.%s(", method.name());
            method.writeRequestConstructor(writer);
            writer.append(");").eol();
        }
        writer.append("    return bean;").eol();
        writer.append("  }").eol();
    }

    List<FieldReader> injectFields() {
        return this.typeReader.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.typeReader.injectMethods();
    }

    boolean isGenerateProxy() {
        return this.aspects.hasAspects() && !this.proxy;
    }

    void writeConstructorParams(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeConstructorParams(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        if (this.constructor != null) {
            writer.append("    super(");
            this.constructor.writeConstructorInit(writer);
            writer.append(");").eol();
        }
    }

    boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    String shortName() {
        return Util.shortName(this.beanQualifiedName());
    }

    String packageName() {
        if (this.importedComponent) {
            return this.beanPackageName() + ".di";
        }
        return this.beanPackageName();
    }

    private String beanPackageName() {
        if (this.beanType.getNestingKind().isNested()) {
            return Util.nestedPackageOf(this.beanQualifiedName());
        }
        return ProcessorUtils.packageOf(this.beanQualifiedName());
    }

    private String beanQualifiedName() {
        return this.beanType.getQualifiedName().toString();
    }

    boolean needsTryForMethodInjection() {
        for (MethodReader injectMethod : this.injectMethods) {
            if (!injectMethod.methodThrows()) continue;
            return true;
        }
        return false;
    }

    boolean isDelayed() {
        return this.delayed;
    }
}

