/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.ProcessorUtils;

final class Dependency {
    private final String name;
    private boolean softDependency;
    private final boolean conditionalDependency;

    Dependency(String name) {
        String nameStr;
        if (name.startsWith("soft:")) {
            this.softDependency = true;
            this.conditionalDependency = false;
            nameStr = ProcessorUtils.trimAnnotations(name.substring(5));
        } else if (name.startsWith("con:")) {
            this.softDependency = true;
            this.conditionalDependency = true;
            nameStr = ProcessorUtils.trimAnnotations(name.substring(4));
        } else {
            this.softDependency = false;
            this.conditionalDependency = false;
            nameStr = ProcessorUtils.trimAnnotations(name);
        }
        this.name = nameStr.replace(",", ", ");
    }

    Dependency(String name, boolean softDependency) {
        this.name = ProcessorUtils.trimAnnotations(name).replace(",", ", ");
        this.softDependency = softDependency;
        this.conditionalDependency = false;
    }

    public String toString() {
        return this.softDependency ? "soft:" + this.name : this.name;
    }

    String name() {
        return this.name;
    }

    boolean isSoftDependency() {
        return this.softDependency;
    }

    public boolean isConditionalDependency() {
        return this.conditionalDependency;
    }

    String dependsOn() {
        return this.toString();
    }

    void markExternal() {
        this.softDependency = true;
    }
}

