/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Processor;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import io.avaje.inject.spi.Module;
import io.avaje.inject.spi.Plugin;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.tools.StandardLocation;

final class ExternalProvider {
    private static final boolean injectAvailable = ExternalProvider.moduleCP();
    private static final Map<String, List<String>> avajePlugins = Map.ofEntries(Map.entry("io.avaje.jsonb.inject.DefaultJsonbProvider", List.of("io.avaje.jsonb.Jsonb")), Map.entry("io.avaje.http.inject.DefaultResolverProvider", List.of("io.avaje.http.api.context.RequestContextResolver")), Map.entry("io.avaje.nima.provider.DefaultConfigProvider", List.of("io.helidon.webserver.WebServerConfig.Builder", "io.helidon.webserver.http.HttpRouting.Builder")), Map.entry("io.avaje.validation.inject.spi.DefaultValidatorProvider", List.of("io.avaje.validation.Validator", "io.avaje.inject.aop.AspectProvider<io.avaje.validation.ValidMethod>")));

    private ExternalProvider() {
    }

    private static boolean moduleCP() {
        try {
            Class.forName("io.avaje.inject.spi.Module");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static void registerModuleProvidedTypes(Set<String> providedTypes) {
        if (!injectAvailable) {
            if (!ExternalProvider.pluginExists("build/avaje-plugin-exists.txt") && !ExternalProvider.pluginExists("target/avaje-plugin-exists.txt")) {
                APContext.logNote("Unable to detect Avaje Inject in Annotation Processor ClassPath, use the Avaje Inject Maven/Gradle plugin for detecting Inject Modules from dependencies", new Object[0]);
            }
            return;
        }
        Iterator<Module> iterator = ServiceLoader.load(Module.class, ExternalProvider.class.getClassLoader()).iterator();
        if (!iterator.hasNext()) {
            APContext.logNote("No external modules detected", new Object[0]);
            return;
        }
        while (iterator.hasNext()) {
            try {
                Module module = iterator.next();
                System.out.println("Detected Module: " + module.getClass().getCanonicalName());
                for (Class provide : module.provides()) {
                    providedTypes.add(provide.getCanonicalName());
                }
                for (Class provide : module.autoProvides()) {
                    providedTypes.add(provide.getCanonicalName());
                }
                for (Class provide : module.autoProvidesAspects()) {
                    providedTypes.add(Util.wrapAspect(provide.getCanonicalName()));
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
    }

    static void registerPluginProvidedTypes(ScopeInfo defaultScope) {
        avajePlugins.forEach((k, v) -> {
            if (APContext.typeElement(k) != null) {
                APContext.logNote("Loaded Plugin: " + k, new Object[0]);
                v.forEach(defaultScope::pluginProvided);
            }
        });
        if (!injectAvailable) {
            return;
        }
        for (Plugin plugin : ServiceLoader.load(Plugin.class, Processor.class.getClassLoader())) {
            String name = plugin.getClass().getCanonicalName();
            if (avajePlugins.containsKey(name)) continue;
            APContext.logNote("Loaded Plugin: " + plugin.getClass().getCanonicalName(), new Object[0]);
            for (Class provide : plugin.provides()) {
                defaultScope.pluginProvided(provide.getCanonicalName());
            }
            for (Class provide : plugin.providesAspects()) {
                defaultScope.pluginProvided(Util.wrapAspect(provide.getCanonicalName()));
            }
        }
    }

    private static boolean pluginExists(String relativeName) {
        try {
            String resource = APContext.filer().getResource(StandardLocation.CLASS_OUTPUT, "", relativeName).toUri().toString().replaceFirst("/target/classes", "").replaceFirst("/build/classes/java/main", "");
            return Paths.get(new URI(resource)).toFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }
}

