/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.AssistedPrism;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.QualifiedMapPrism;
import io.avaje.inject.generator.UType;
import io.avaje.inject.generator.Util;
import io.avaje.inject.generator.UtilType;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;

final class FieldReader {
    private final Element element;
    private final String name;
    private final UtilType utype;
    private final boolean nullable;
    private final String fieldType;
    private final UType type;
    private boolean requestParam;
    private String requestParamName;
    private final boolean isBeanMap;
    private final boolean assisted;

    FieldReader(Element element) {
        this.element = element;
        this.name = Util.getNamed(element);
        this.nullable = Util.isNullable(element);
        this.utype = Util.determineType(element.asType());
        this.isBeanMap = QualifiedMapPrism.isPresent(element);
        this.fieldType = Util.unwrapProvider(this.utype.rawType(this.isBeanMap));
        this.type = this.utype.toUType();
        this.assisted = AssistedPrism.isPresent(element);
        if (this.nullable || element.asType().toString().startsWith("java.util.Optional<")) {
            ProcessingContext.addOptionalType(this.fieldType);
        }
    }

    boolean isGenericParam() {
        return this.type.isGeneric() && !Util.isProvider(this.type.mainType());
    }

    void addDependsOnGeneric(Set<UType> set) {
        if (this.isGenericParam()) {
            set.add(this.type);
        }
    }

    String fieldName() {
        return this.element.getSimpleName().toString();
    }

    void addImports(ImportTypeMap importTypes) {
        importTypes.addAll(this.type.importTypes());
    }

    String builderGetDependency(String builder) {
        StringBuilder sb = new StringBuilder();
        sb.append(builder).append(".").append(this.utype.getMethod(this.nullable, this.isBeanMap));
        if (this.isGenericParam()) {
            sb.append("TYPE_").append(Util.shortName(this.type).replace(".", "_"));
        } else {
            String trimmed = ProcessorUtils.trimAnnotations(this.fieldType);
            sb.append(Util.shortName(trimmed)).append(".class");
        }
        if (this.name != null) {
            sb.append(",\"").append(this.name).append("\"");
        }
        sb.append(")");
        return sb.toString();
    }

    void removeFromProvides(List<UType> provides) {
        provides.remove(this.type);
    }

    void checkRequest(BeanRequestParams requestParams) {
        this.requestParam = requestParams.check(this.utype.rawType(this.isBeanMap));
        if (this.requestParam) {
            this.requestParamName = requestParams.argumentName(this.utype.rawType(this.isBeanMap));
        }
    }

    void writeRequestDependency(Append writer) {
        if (!this.requestParam) {
            this.requestParamName = writer.nextName(this.fieldName().toLowerCase());
            writer.append("  @Inject").eol().append("  ");
            writer.append(this.type.shortType());
            writer.append(" %s;", this.requestParamName).eol().eol();
        }
    }

    void writeRequestInject(Append writer) {
        writer.append("    bean.%s = %s;", this.fieldName(), this.requestParamName).eol();
    }

    Element element() {
        return this.element;
    }

    boolean assisted() {
        return this.assisted;
    }
}

