/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanReader;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.DependencyMetaPrism;
import io.avaje.inject.generator.ProcessorUtils;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class MetaData {
    private static final String NEWLINE = "\n";
    private final String type;
    private final String shortType;
    private final String name;
    private String method;
    private boolean wired;
    private String providesAspect;
    private List<String> provides;
    private List<Dependency> dependsOn;
    private List<String> autoProvides;
    private boolean generateProxy;
    private boolean usesExternalDependency;
    private final Set<String> externalDependencies = new HashSet<String>();
    private boolean importedComponent;

    MetaData(DependencyMetaPrism meta) {
        this.type = meta.type();
        this.name = this.trimName(meta.name());
        this.shortType = Util.shortName(this.type);
        this.method = meta.method();
        this.providesAspect = meta.providesAspect();
        this.provides = meta.provides();
        this.dependsOn = meta.dependsOn().stream().map(Dependency::new).collect(Collectors.toList());
        this.autoProvides = meta.autoProvides();
        this.importedComponent = meta.importedComponent();
    }

    MetaData(String type, String name) {
        this.type = type;
        this.name = this.trimName(name);
        this.shortType = Util.shortName(type);
        this.provides = new ArrayList<String>();
        this.dependsOn = new ArrayList<Dependency>();
    }

    public String toString() {
        return this.name == null ? this.type : this.type + ":" + this.name;
    }

    boolean importedComponent() {
        return this.importedComponent;
    }

    boolean isGenerateProxy() {
        return this.generateProxy;
    }

    private String trimName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        return name.replace("\\\"", "'");
    }

    String buildName() {
        if (Util.isVoid(this.type)) {
            return "void_" + Util.trimMethod(this.method);
        }
        String trimType = Util.trimMethod(Util.unwrapProvider(this.type));
        if (this.name != null) {
            return trimType + "_" + this.name.replaceAll("[^a-zA-Z0-9_$]+", "_");
        }
        return trimType;
    }

    public String key() {
        if (Util.isVoid(this.type)) {
            return "method:" + this.method;
        }
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean noDepends() {
        return this.dependsOn == null || this.dependsOn.isEmpty();
    }

    boolean isWired() {
        return this.wired;
    }

    void setWired() {
        this.wired = true;
    }

    void update(BeanReader beanReader) {
        this.provides = beanReader.provides();
        this.dependsOn = beanReader.dependsOn();
        this.providesAspect = beanReader.providesAspect();
        this.autoProvides = beanReader.autoProvides();
        this.generateProxy = beanReader.isGenerateProxy();
        this.importedComponent = beanReader.importedComponent();
    }

    String type() {
        return this.type;
    }

    List<String> provides() {
        return this.provides;
    }

    List<Dependency> dependsOn() {
        return this.dependsOn;
    }

    List<String> autoProvides() {
        return this.autoProvides;
    }

    String providesAspect() {
        return this.providesAspect;
    }

    String topPackage() {
        if (this.method == null || this.method.isEmpty()) {
            return ProcessorUtils.packageOf(this.type);
        }
        return null;
    }

    void addImportTypes(Set<String> importTypes) {
        if (this.hasMethod()) {
            importTypes.add(Util.classOfMethod(this.method));
        } else if (!this.generateProxy) {
            if (this.importedComponent) {
                String packageName = APContext.typeElement(this.type).getNestingKind().isNested() ? Util.nestedPackageOf(this.type) : ProcessorUtils.packageOf(this.type);
                importTypes.add(packageName + ".di." + this.shortType + "$DI");
            } else {
                importTypes.add(this.type + "$DI");
            }
        }
    }

    void buildMethod(Append append) {
        if (this.generateProxy) {
            return;
        }
        if (this.usesExternalDependency) {
            append.append("  // uses external dependency " + String.valueOf(this.externalDependencies) + NEWLINE);
        }
        boolean hasName = this.name != null;
        boolean hasMethod = this.hasMethod();
        boolean hasProvidesAspect = !this.providesAspect.isEmpty();
        boolean hasDependsOn = !this.dependsOn.isEmpty();
        boolean hasProvides = !this.provides.isEmpty();
        boolean hasAutoProvides = this.autoProvides != null && !this.autoProvides.isEmpty();
        append.append("  @DependencyMeta(");
        if (hasName || hasMethod || hasProvidesAspect || hasDependsOn || hasProvides || hasAutoProvides) {
            append.eol().append("      ");
        }
        append.append("type = \"").append(this.type).append("\"");
        if (hasName) {
            append.append(",").eol().append("      name = \"").append(this.name).append("\"");
        }
        if (this.importedComponent) {
            append.append(",").eol().append("      importedComponent = true");
        }
        if (hasMethod) {
            append.append(",").eol().append("      method = \"").append(this.method).append("\"");
        }
        if (hasProvidesAspect) {
            append.append(",").eol().append("      providesAspect = \"").append(this.providesAspect).append("\"");
        } else if (hasProvides) {
            this.appendProvides(append, "provides", this.provides);
        }
        if (hasDependsOn) {
            this.appendProvides(append, "dependsOn", this.dependsOn.stream().map(Dependency::dependsOn).collect(Collectors.toList()));
        }
        if (hasAutoProvides) {
            this.appendProvides(append, "autoProvides", this.autoProvides);
        }
        append.append(")").append(NEWLINE);
        append.append("  private void build_").append(this.buildName()).append("() {").append(NEWLINE);
        if (this.hasMethod()) {
            append.append("    ").append(Util.shortMethod(this.method)).append("(builder");
        } else {
            append.append("    ").append(this.shortType).append("$DI").append(".build(builder");
        }
        append.append(");").append(NEWLINE);
        append.append("  }").append(NEWLINE);
        append.eol();
    }

    private boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    private void appendProvides(Append sb, String attribute, List<String> types) {
        sb.append(",").eol().append("      ").append(attribute).append(" = {");
        int size = types.size();
        if (size > 1) {
            sb.eol().append("        ");
        }
        HashSet<String> seen = new HashSet<String>();
        for (int i = 0; i < types.size(); ++i) {
            if (!seen.add(types.get(i))) continue;
            if (i > 0) {
                sb.append(",").eol().append("        ");
            }
            sb.append("\"");
            sb.append(types.get(i));
            sb.append("\"");
        }
        if (size > 1) {
            sb.eol().append("      ");
        }
        sb.append("}");
    }

    void setProvides(List<String> provides) {
        this.provides = provides;
    }

    void setDependsOn(List<String> dependsOn) {
        this.dependsOn = dependsOn.stream().map(Dependency::new).collect(Collectors.toList());
    }

    void setMethod(String method) {
        this.method = method;
    }

    void setAutoProvides(List<String> autoProvides) {
        this.autoProvides = autoProvides;
    }

    void setProvidesAspect(String providesAspect) {
        this.providesAspect = providesAspect;
    }

    void markWithExternalDependency(String name) {
        this.usesExternalDependency = true;
        this.externalDependencies.add(name);
        for (Dependency dependency : this.dependsOn) {
            if (!name.equals(dependency.name())) continue;
            dependency.markExternal();
        }
    }
}

