/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.APContext;
import io.avaje.inject.generator.AnnotationCopier;
import io.avaje.inject.generator.QualifierPrism;
import io.avaje.inject.generator.Util;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class TypeAnnotationReader {
    private final TypeElement beanType;
    private String qualifierName;

    TypeAnnotationReader(TypeElement beanType) {
        this.beanType = beanType;
    }

    boolean hasQualifierName() {
        return this.qualifierName != null;
    }

    String qualifierName() {
        return this.qualifierName;
    }

    void process() {
        for (AnnotationMirror annotationMirror : this.beanType.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            String annType = annotationType.toString();
            if (QualifierPrism.isPresent(annotationType.asElement())) {
                String shortName = Util.shortName(annotationType.toString());
                this.qualifierName = AnnotationCopier.toSimpleAnnotationString(annotationMirror).replaceFirst(annotationType.toString(), shortName).replace("\"", "\\\"").toLowerCase();
                continue;
            }
            if (annType.indexOf(46) != -1) continue;
            APContext.logWarn("skip when no package on annotation " + annType, new Object[0]);
        }
    }
}

