/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.NamedPrism;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.TypeAnnotationReader;
import io.avaje.inject.generator.TypeAppender;
import io.avaje.inject.generator.TypeExtendsReader;
import io.avaje.inject.generator.UType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class TypeReader {
    private final boolean forBean;
    private final TypeElement beanType;
    private final ImportTypeMap importTypes;
    private final TypeExtendsReader extendsReader;
    private final TypeAnnotationReader annotationReader;
    private Set<UType> genericTypes;
    private String typesRegister;

    TypeReader(UType genericType, TypeElement beanType, ImportTypeMap importTypes, boolean factory) {
        this(genericType, true, beanType, importTypes, factory);
    }

    TypeReader(UType genericType, TypeElement returnElement, ImportTypeMap importTypes) {
        this(genericType, false, returnElement, importTypes, false);
    }

    private TypeReader(UType genericType, boolean forBean, TypeElement beanType, ImportTypeMap importTypes, boolean factory) {
        this.forBean = forBean;
        this.beanType = beanType;
        this.importTypes = importTypes;
        boolean proxyBean = forBean && ProxyPrism.isPresent(beanType);
        this.extendsReader = new TypeExtendsReader(genericType, beanType, factory, importTypes, proxyBean);
        this.annotationReader = new TypeAnnotationReader(beanType);
    }

    String typesRegister() {
        return this.typesRegister;
    }

    List<String> provides() {
        return this.extendsReader.provides().stream().map(UType::full).collect(Collectors.toList());
    }

    List<String> autoProvides() {
        return this.extendsReader.autoProvides().stream().map(UType::full).collect(Collectors.toList());
    }

    String providesAspect() {
        return this.extendsReader.providesAspect();
    }

    boolean isClosable() {
        return this.extendsReader.isCloseable();
    }

    BeanAspects hasAspects() {
        return this.extendsReader.hasAspects();
    }

    List<FieldReader> injectFields() {
        return this.extendsReader.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.extendsReader.injectMethods();
    }

    List<MethodReader> factoryMethods() {
        return this.extendsReader.factoryMethods();
    }

    Element postConstructMethod() {
        return this.extendsReader.postConstructMethod();
    }

    Element preDestroyMethod() {
        return this.extendsReader.preDestroyMethod();
    }

    Integer preDestroyPriority() {
        return this.extendsReader.preDestroyPriority();
    }

    MethodReader constructor() {
        return this.extendsReader.constructor();
    }

    Set<UType> genericTypes() {
        return this.genericTypes;
    }

    void process() {
        this.extendsReader.process(this.forBean);
        if (this.forBean) {
            this.annotationReader.process();
        }
        this.initRegistrationTypes();
    }

    String name() {
        NamedPrism named = NamedPrism.getInstanceOn(this.beanType);
        if (named != null) {
            return named.value().toLowerCase();
        }
        if (this.annotationReader.hasQualifierName()) {
            return this.annotationReader.qualifierName();
        }
        return this.extendsReader.qualifierName();
    }

    private void initRegistrationTypes() {
        TypeAppender appender = new TypeAppender(this.importTypes);
        appender.add(this.extendsReader.baseType());
        appender.add(this.extendsReader.provides());
        this.genericTypes = appender.genericTypes();
        this.typesRegister = appender.asString();
    }

    void extraImports(ImportTypeMap importTypes) {
        if (!this.genericTypes.isEmpty()) {
            importTypes.add("java.lang.reflect.Type");
            importTypes.add("io.avaje.inject.spi.GenericType");
            this.genericTypes.forEach(t -> importTypes.addAll(t.importTypes()));
        }
    }
}

