/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.InjectModulePrism;
import io.avaje.inject.generator.ProcessingContext;
import io.avaje.inject.generator.ScopeInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class AllScopes {
    private final Map<String, Data> scopeAnnotations = new HashMap<String, Data>();
    private final ScopeInfo defaultScope = new ScopeInfo();

    AllScopes() {
    }

    ScopeInfo defaultScope() {
        return this.defaultScope;
    }

    ScopeInfo addScopeAnnotation(TypeElement type) {
        String key = type.getQualifiedName().toString();
        Data existing = this.scopeAnnotations.get(key);
        if (existing != null) {
            return existing.scopeInfo;
        }
        Data data = new Data(type, this);
        this.scopeAnnotations.put(key, data);
        return data.scopeInfo;
    }

    boolean providedByDefaultScope(String dependency) {
        return this.defaultScope.providesDependencyLocally(dependency);
    }

    void readBeans(RoundEnvironment roundEnv) {
        for (Data data : this.scopeAnnotations.values()) {
            for (Element element : roundEnv.getElementsAnnotatedWith(data.type)) {
                if (!(element instanceof TypeElement)) continue;
                data.scopeInfo.read((TypeElement)element, false);
            }
        }
    }

    void write(boolean processingOver) {
        for (Data value : this.scopeAnnotations.values()) {
            value.write(processingOver);
        }
        for (Data value : this.scopeAnnotations.values()) {
            value.writeCustomModule();
        }
    }

    void readModules(List<String> customScopeModules) {
        for (String customScopeModule : customScopeModules) {
            InjectModulePrism injectModule;
            TypeElement module = ProcessingContext.element(customScopeModule);
            if (module == null || (injectModule = InjectModulePrism.getInstanceOn(module)) == null) continue;
            String customScopeType = injectModule.customScopeType();
            TypeElement scopeType = ProcessingContext.element(customScopeType);
            if (scopeType == null) {
                ProcessingContext.logError(module, "customScopeType [" + customScopeType + "] is invalid? on " + String.valueOf(module), new Object[0]);
                continue;
            }
            ScopeInfo scopeInfo = this.addScopeAnnotation(scopeType);
            scopeInfo.readModuleMetaData(module);
        }
    }

    ScopeInfo get(String fullType) {
        Data data = this.scopeAnnotations.get(fullType);
        return data == null ? null : data.scopeInfo;
    }

    static class Data {
        final TypeElement type;
        final ScopeInfo scopeInfo;

        Data(TypeElement type, AllScopes allScopes) {
            this.type = type;
            this.scopeInfo = new ScopeInfo(type, allScopes);
            this.scopeInfo.details(null, type);
        }

        void write(boolean processingOver) {
            this.scopeInfo.write(processingOver);
        }

        void writeCustomModule() {
            this.scopeInfo.writeCustomModule();
        }
    }
}

