/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Append;
import io.avaje.inject.generator.BeanAspects;
import io.avaje.inject.generator.BeanConditions;
import io.avaje.inject.generator.BeanRequestParams;
import io.avaje.inject.generator.ConditionalWriter;
import io.avaje.inject.generator.Dependency;
import io.avaje.inject.generator.FieldReader;
import io.avaje.inject.generator.GenericType;
import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.MetaData;
import io.avaje.inject.generator.MethodReader;
import io.avaje.inject.generator.PrimaryPrism;
import io.avaje.inject.generator.PrototypePrism;
import io.avaje.inject.generator.ProxyPrism;
import io.avaje.inject.generator.SecondaryPrism;
import io.avaje.inject.generator.TypeReader;
import io.avaje.inject.generator.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class BeanReader {
    private final TypeElement beanType;
    private final String shortName;
    private final String type;
    private final String name;
    private final MethodReader constructor;
    private final List<FieldReader> injectFields;
    private final List<MethodReader> injectMethods;
    private final List<MethodReader> factoryMethods;
    private final Element postConstructMethod;
    private final Element preDestroyMethod;
    private final ImportTypeMap importTypes = new ImportTypeMap();
    private final BeanRequestParams requestParams;
    private final TypeReader typeReader;
    private final boolean prototype;
    private final boolean primary;
    private final boolean secondary;
    private final boolean proxy;
    private final BeanAspects aspects;
    private final BeanConditions conditions = new BeanConditions();
    private boolean writtenToFile;
    private boolean suppressBuilderImport;
    private boolean suppressGeneratedImport;
    private Set<GenericType> allGenericTypes;

    BeanReader(TypeElement beanType, boolean factory) {
        this.beanType = beanType;
        this.type = beanType.getQualifiedName().toString();
        this.shortName = this.shortName(beanType);
        this.prototype = PrototypePrism.isPresent(beanType);
        this.primary = PrimaryPrism.isPresent(beanType);
        this.secondary = !this.primary && SecondaryPrism.isPresent(beanType);
        this.proxy = ProxyPrism.isPresent(beanType);
        this.typeReader = new TypeReader(GenericType.parse(this.type), beanType, this.importTypes, factory);
        this.conditions.readAll(beanType);
        this.typeReader.process();
        this.requestParams = new BeanRequestParams(this.type);
        this.name = this.typeReader.name();
        this.aspects = this.typeReader.hasAspects();
        this.injectMethods = this.typeReader.injectMethods();
        this.injectFields = this.typeReader.injectFields();
        this.factoryMethods = this.typeReader.factoryMethods();
        this.postConstructMethod = this.typeReader.postConstructMethod();
        this.preDestroyMethod = this.typeReader.preDestroyMethod();
        this.constructor = this.typeReader.constructor();
    }

    public String toString() {
        return this.beanType.toString();
    }

    TypeElement beanType() {
        return this.beanType;
    }

    BeanAspects aspects() {
        return this.aspects;
    }

    boolean prototype() {
        return this.prototype;
    }

    BeanReader read() {
        if (this.constructor != null) {
            this.constructor.addImports(this.importTypes);
            this.constructor.checkRequest(this.requestParams);
        }
        for (FieldReader field : this.injectFields) {
            field.addImports(this.importTypes);
            field.checkRequest(this.requestParams);
        }
        for (MethodReader method : this.injectMethods) {
            method.addImports(this.importTypes);
            method.checkRequest(this.requestParams);
        }
        for (MethodReader factoryMethod : this.factoryMethods) {
            factoryMethod.addImports(this.importTypes);
        }
        this.conditions.addImports(this.importTypes);
        return this;
    }

    List<Dependency> dependsOn() {
        ArrayList<Dependency> list = new ArrayList<Dependency>();
        if (this.constructor != null) {
            for (MethodReader.MethodParam param : this.constructor.params()) {
                Dependency dependsOn = param.dependsOn();
                if (dependsOn.dependsOn().equals("io.avaje.inject.BeanScope")) continue;
                list.add(dependsOn);
            }
        }
        this.conditions.requireTypes.stream().map(t -> new Dependency("con:" + t)).forEach(list::add);
        this.conditions.missingTypes.stream().filter(t -> !t.equals(this.type)).map(t -> new Dependency("con:" + t)).forEach(list::add);
        return list;
    }

    List<MethodReader> factoryMethods() {
        return this.factoryMethods;
    }

    List<String> provides() {
        return this.typeReader.provides();
    }

    String autoProvides() {
        return this.typeReader.autoProvides();
    }

    String providesAspect() {
        return this.typeReader.providesAspect();
    }

    Set<GenericType> allGenericTypes() {
        if (this.allGenericTypes != null) {
            return this.allGenericTypes;
        }
        this.allGenericTypes = new LinkedHashSet<GenericType>(this.typeReader.genericTypes());
        for (FieldReader field : this.injectFields) {
            field.addDependsOnGeneric(this.allGenericTypes);
        }
        for (MethodReader method : this.injectMethods) {
            method.addDependsOnGeneric(this.allGenericTypes);
        }
        if (this.constructor != null) {
            this.constructor.addDependsOnGeneric(this.allGenericTypes);
        }
        for (MethodReader factoryMethod : this.factoryMethods()) {
            factoryMethod.addDependsOnGeneric(this.allGenericTypes);
        }
        return this.allGenericTypes;
    }

    private String shortName(Element element) {
        return element.getSimpleName().toString();
    }

    String metaKey() {
        if (this.name != null) {
            return this.type + ":" + this.name;
        }
        return this.type;
    }

    boolean hasLifecycleMethods() {
        return this.postConstructMethod != null || this.preDestroyMethod != null || this.typeReader.isClosable();
    }

    List<MetaData> createFactoryMethodMeta() {
        if (this.factoryMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MetaData> metaList = new ArrayList<MetaData>(this.factoryMethods.size());
        for (MethodReader factoryMethod : this.factoryMethods) {
            metaList.add(factoryMethod.createMeta());
        }
        return metaList;
    }

    MetaData createMeta() {
        Object type = this.beanType.getNestingKind().isNested() ? this.beanType.getEnclosingElement().toString() + "$" + String.valueOf(this.beanType.getSimpleName()) : this.beanType.getQualifiedName().toString();
        MetaData metaData = new MetaData((String)type, this.name);
        metaData.update(this);
        return metaData;
    }

    boolean isExtraInjectionRequired() {
        return !this.injectFields.isEmpty() || !this.injectMethods.isEmpty();
    }

    void buildConditional(Append writer) {
        new ConditionalWriter(writer, this.conditions).write();
    }

    void buildAddFor(Append writer) {
        writer.append("    if (builder.isAddBeanFor(");
        if (this.name != null && !this.name.isEmpty()) {
            writer.append("\"%s\", ", this.name);
        }
        writer.append(this.typeReader.typesRegister());
        writer.append(")) {").eol();
    }

    void buildRegister(Append writer) {
        if (this.prototype) {
            return;
        }
        writer.append("      ");
        if (this.isExtraInjectionRequired() || this.hasLifecycleMethods()) {
            writer.append("var $bean = ");
        }
        writer.append("builder.");
        if (this.primary) {
            writer.append("asPrimary().");
        } else if (this.secondary) {
            writer.append("asSecondary().");
        }
        writer.append("register(bean);").eol();
    }

    void addLifecycleCallbacks(Append writer, String indent) {
        if (this.postConstructMethod != null && !this.prototype) {
            writer.append("%s builder.addPostConstruct($bean::%s);", indent, this.postConstructMethod.getSimpleName()).eol();
        }
        if (this.preDestroyMethod != null) {
            this.prototypeNotSupported("@PreDestroy");
            writer.append("%s builder.addPreDestroy($bean::%s);", indent, this.preDestroyMethod.getSimpleName()).eol();
        } else if (this.typeReader.isClosable() && !this.prototype) {
            writer.append("%s builder.addPreDestroy($bean);", indent).eol();
        }
    }

    void prototypePostConstruct(Append writer, String indent) {
        if (this.postConstructMethod != null) {
            writer.append("%s bean.%s();", indent, this.postConstructMethod.getSimpleName()).eol();
        }
    }

    private void prototypeNotSupported(String lifecycle) {
        if (this.prototype) {
            throw new IllegalStateException(String.format("@Prototype scoped bean does not support %s lifecycle method", lifecycle));
        }
    }

    private Set<String> importTypes() {
        if (Util.validImportType(this.type)) {
            this.importTypes.add(this.type);
        }
        this.typeReader.extraImports(this.importTypes);
        this.requestParams.addImports(this.importTypes);
        this.aspects.extraImports(this.importTypes);
        for (MethodReader factoryMethod : this.factoryMethods) {
            Set<GenericType> genericTypes = factoryMethod.genericTypes();
            if (genericTypes.isEmpty()) continue;
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
        }
        this.checkImports();
        if (!this.suppressGeneratedImport) {
            this.importTypes.add("io.avaje.inject.spi.Generated");
        }
        if (!this.suppressBuilderImport) {
            this.importTypes.add("io.avaje.inject.spi.Builder");
        }
        return this.importTypes.forImport();
    }

    private void checkImports() {
        this.suppressBuilderImport = this.importTypes.containsShortName("Builder");
        this.suppressGeneratedImport = this.importTypes.containsShortName("Generated");
    }

    String builderType() {
        return this.suppressBuilderImport ? "io.avaje.inject.spi.Builder" : "Builder";
    }

    String generatedType() {
        return this.suppressGeneratedImport ? "@io.avaje.inject.spi.Generated" : "@Generated";
    }

    void writeImports(Append writer) {
        if (!this.allGenericTypes().isEmpty()) {
            this.importTypes.add("java.lang.reflect.Type");
            this.importTypes.add("io.avaje.inject.spi.GenericType");
        }
        for (String importType : this.importTypes()) {
            if (!Util.validImportType(importType)) continue;
            writer.append("import %s;", importType).eol();
        }
        writer.eol();
    }

    MethodReader constructor() {
        return this.constructor;
    }

    boolean isWrittenToFile() {
        return this.writtenToFile;
    }

    void setWrittenToFile() {
        this.writtenToFile = true;
    }

    boolean isRequestScopedController() {
        return this.requestParams.isRequestScopedController();
    }

    String suffix() {
        return this.isRequestScopedController() ? "$Factory" : "$DI";
    }

    void factoryInterface(Append writer) {
        this.requestParams.factoryInterface(writer);
    }

    void writeRequestCreate(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeRequestDependency(writer);
        }
        for (FieldReader field : this.injectFields) {
            field.writeRequestDependency(writer);
        }
        for (MethodReader method : this.injectMethods) {
            method.writeRequestDependency(writer);
        }
        this.requestParams.writeRequestCreate(writer);
        writer.resetNextName();
        writer.append("    var bean = new %s(", this.shortName);
        if (this.constructor != null) {
            this.constructor.writeRequestConstructor(writer);
        }
        writer.append(");").eol();
        for (FieldReader field : this.injectFields) {
            field.writeRequestInject(writer);
        }
        for (MethodReader method : this.injectMethods) {
            writer.append("    bean.%s(", method.name());
            method.writeRequestConstructor(writer);
            writer.append(");").eol();
        }
        writer.append("    return bean;").eol();
        writer.append("  }").eol();
    }

    List<FieldReader> injectFields() {
        return this.typeReader.injectFields();
    }

    List<MethodReader> injectMethods() {
        return this.typeReader.injectMethods();
    }

    boolean isGenerateProxy() {
        return this.aspects.hasAspects() && !this.proxy;
    }

    void writeConstructorParams(Append writer) {
        if (this.constructor != null) {
            this.constructor.writeConstructorParams(writer);
        }
    }

    void writeConstructorInit(Append writer) {
        if (this.constructor != null) {
            writer.append("    super(");
            this.constructor.writeConstructorInit(writer);
            writer.append(");").eol();
        }
    }

    boolean hasConditions() {
        return !this.conditions.isEmpty();
    }
}

