/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Util;

final class Dependency {
    private final String name;
    private final boolean softDependency;
    private final boolean conditionalDependency;

    Dependency(String name) {
        if (name.startsWith("soft:")) {
            this.softDependency = true;
            this.conditionalDependency = false;
            this.name = Util.trimAnnotations(name.substring(5));
        } else if (name.startsWith("con:")) {
            this.softDependency = true;
            this.conditionalDependency = true;
            this.name = Util.trimAnnotations(name.substring(4));
        } else {
            this.softDependency = false;
            this.conditionalDependency = false;
            this.name = Util.trimAnnotations(name);
        }
    }

    Dependency(String name, boolean softDependency) {
        this.name = Util.trimAnnotations(name);
        this.softDependency = softDependency;
        this.conditionalDependency = false;
    }

    public String toString() {
        return this.softDependency ? "soft:" + this.name : this.name;
    }

    String name() {
        return this.name;
    }

    boolean isSoftDependency() {
        return this.softDependency;
    }

    public boolean isConditionalDependency() {
        return this.conditionalDependency;
    }

    String dependsOn() {
        return this.toString();
    }
}

