/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.Processor;
import io.avaje.inject.generator.ScopeInfo;
import io.avaje.inject.generator.Util;
import io.avaje.inject.spi.Module;
import io.avaje.inject.spi.Plugin;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;

final class ExternalProvider {
    private static final boolean injectAvailable = ExternalProvider.moduleCP();

    private ExternalProvider() {
    }

    private static boolean moduleCP() {
        try {
            Class.forName("io.avaje.inject.spi.Module");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static void registerModuleProvidedTypes(Set<String> providedTypes) {
        if (!injectAvailable) {
            return;
        }
        Iterator<Module> iterator = ServiceLoader.load(Module.class, ExternalProvider.class.getClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                Module module = iterator.next();
                for (Class provide : module.provides()) {
                    providedTypes.add(provide.getCanonicalName());
                }
                for (Class provide : module.autoProvides()) {
                    providedTypes.add(provide.getCanonicalName());
                }
                for (Class provide : module.autoProvidesAspects()) {
                    providedTypes.add(Util.wrapAspect(provide.getCanonicalName()));
                }
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
            }
        }
    }

    static void registerPluginProvidedTypes(ScopeInfo defaultScope) {
        if (!injectAvailable) {
            return;
        }
        for (Plugin plugin : ServiceLoader.load(Plugin.class, Processor.class.getClassLoader())) {
            for (Class provide : plugin.provides()) {
                defaultScope.pluginProvided(provide.getCanonicalName());
            }
        }
    }
}

