/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

final class AspectPrism {
    private final Integer _ordering;
    public static final String PRISM_TYPE = "io.avaje.inject.aop.Aspect";
    final Values values;
    final boolean isValid;
    final AnnotationMirror mirror;
    private final Map<String, AnnotationValue> defaults = new HashMap<String, AnnotationValue>(10);
    private final Map<String, AnnotationValue> memberValues = new HashMap<String, AnnotationValue>(10);
    private boolean valid = true;

    static boolean isPresent(Element element) {
        return AspectPrism.getInstanceOn(element) != null;
    }

    static AspectPrism getInstanceOn(Element element) {
        AnnotationMirror mirror = AspectPrism.getMirror(element);
        if (mirror == null) {
            return null;
        }
        return AspectPrism.getInstance(mirror);
    }

    static Optional<AspectPrism> getOptionalOn(Element element) {
        AnnotationMirror mirror = AspectPrism.getMirror(element);
        if (mirror == null) {
            return Optional.empty();
        }
        return AspectPrism.getOptional(mirror);
    }

    static List<AspectPrism> getAllOnMetaAnnotations(Element element) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return List.of();
        }
        return AspectPrism.getAllOnMetaAnnotations(element, new HashSet<String>()).collect(Collectors.toList());
    }

    private static Stream<AspectPrism> getAllOnMetaAnnotations(Element element, Set<String> seen) {
        if (element == null || element.getAnnotationMirrors().isEmpty()) {
            return Stream.of(new AspectPrism[0]);
        }
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).filter(t -> seen.add(t.toString())).map(DeclaredType::asElement).flatMap(e -> Stream.concat(AspectPrism.getAllOnMetaAnnotations(e, seen), AspectPrism.getMirrors(element).map(AspectPrism::getInstance)));
    }

    static AspectPrism getInstance(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return null;
        }
        return new AspectPrism(mirror);
    }

    static Optional<AspectPrism> getOptional(AnnotationMirror mirror) {
        if (mirror == null || !PRISM_TYPE.equals(mirror.getAnnotationType().toString())) {
            return Optional.empty();
        }
        return Optional.of(new AspectPrism(mirror));
    }

    private AspectPrism(AnnotationMirror mirror) {
        for (ExecutableElement executableElement : mirror.getElementValues().keySet()) {
            this.memberValues.put(executableElement.getSimpleName().toString(), mirror.getElementValues().get(executableElement));
        }
        for (ExecutableElement executableElement : ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements())) {
            this.defaults.put(executableElement.getSimpleName().toString(), executableElement.getDefaultValue());
        }
        this._ordering = this.getValue("ordering", Integer.class);
        this.values = new Values(this.memberValues);
        this.mirror = mirror;
        this.isValid = this.valid;
    }

    public Integer ordering() {
        return this._ordering;
    }

    private <T> T getValue(String name, Class<T> clazz) {
        T result = AspectPrism.getValue(this.memberValues, this.defaults, name, clazz);
        if (result == null) {
            this.valid = false;
        }
        return result;
    }

    private static AnnotationMirror getMirror(Element target) {
        for (AnnotationMirror annotationMirror : target.getAnnotationMirrors()) {
            Name mfqn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!PRISM_TYPE.contentEquals(mfqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    private static Stream<? extends AnnotationMirror> getMirrors(Element target) {
        return target.getAnnotationMirrors().stream().filter(m -> PRISM_TYPE.contentEquals(((TypeElement)m.getAnnotationType().asElement()).getQualifiedName()));
    }

    private static <T> T getValue(Map<String, AnnotationValue> memberValues, Map<String, AnnotationValue> defaults, String name, Class<T> clazz) {
        AnnotationValue av = memberValues.get(name);
        if (av == null) {
            av = defaults.get(name);
        }
        if (av == null) {
            return null;
        }
        if (clazz.isInstance(av.getValue())) {
            return clazz.cast(av.getValue());
        }
        return null;
    }

    static final class Values {
        private final Map<String, AnnotationValue> values;

        private Values(Map<String, AnnotationValue> values) {
            this.values = values;
        }

        AnnotationValue ordering() {
            return this.values.get("ordering");
        }
    }
}

