/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import io.avaje.inject.generator.ImportTypeMap;
import io.avaje.inject.generator.ProfilePrism;
import io.avaje.inject.generator.RequiresBeanContainerPrism;
import io.avaje.inject.generator.RequiresBeanPrism;
import io.avaje.inject.generator.RequiresPropertyContainerPrism;
import io.avaje.inject.generator.RequiresPropertyPrism;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;

final class BeanConditions {
    final Set<String> requireTypes = new HashSet<String>();
    final Set<String> missingTypes = new HashSet<String>();
    final Set<String> qualifierNames = new HashSet<String>();
    final Set<String> containsProps = new HashSet<String>();
    final Set<String> missingProps = new HashSet<String>();
    final Set<String> orProfiles = new HashSet<String>();
    final Set<String> andProfiles = new HashSet<String>();
    final Set<String> notProfiles = new HashSet<String>();
    final Map<String, String> propertyEquals = new HashMap<String, String>();
    final Map<String, String> propertyNotEquals = new HashMap<String, String>();

    BeanConditions() {
    }

    void readAll(Element element) {
        this.readAllDirect(element);
        this.readMetaAnnotations(element);
    }

    private void readAllDirect(Element element) {
        RequiresBeanPrism.getAllInstancesOn(element).forEach(this::read);
        RequiresBeanContainerPrism.getOptionalOn(element).ifPresent(container -> container.value().forEach(this::read));
        RequiresPropertyPrism.getAllInstancesOn(element).forEach(this::read);
        RequiresPropertyContainerPrism.getOptionalOn(element).ifPresent(container -> container.value().forEach(this::read));
        ProfilePrism.getOptionalOn(element).ifPresent(this::read);
    }

    private void readMetaAnnotations(Element element) {
        RequiresBeanPrism.getAllOnMetaAnnotations(element).forEach(this::read);
        RequiresBeanContainerPrism.getAllOnMetaAnnotations(element).stream().flatMap(e -> e.value().stream()).forEach(this::read);
        RequiresPropertyPrism.getAllOnMetaAnnotations(element).forEach(this::read);
        RequiresPropertyContainerPrism.getAllOnMetaAnnotations(element).stream().flatMap(e -> e.value().stream()).forEach(this::read);
        ProfilePrism.getAllOnMetaAnnotations(element).forEach(this::read);
    }

    private void read(ProfilePrism prism) {
        this.orProfiles.addAll(prism.value());
        this.andProfiles.addAll(prism.all());
        this.notProfiles.addAll(prism.none());
    }

    private void read(RequiresBeanPrism prism) {
        prism.value().forEach(t -> this.requireTypes.add(t.toString()));
        prism.missing().forEach(t -> this.missingTypes.add(t.toString()));
        this.qualifierNames.addAll(prism.qualifiers());
    }

    private void read(RequiresPropertyPrism prism) {
        if (!prism.value().isBlank()) {
            if (!prism.notEqualTo().isBlank()) {
                this.propertyNotEquals.put(prism.value(), prism.notEqualTo());
            } else if (!prism.equalTo().isBlank()) {
                this.propertyEquals.put(prism.value(), prism.equalTo());
            } else {
                this.containsProps.add(prism.value());
            }
        }
        this.missingProps.addAll(prism.missing());
    }

    void addImports(ImportTypeMap importTypes) {
        this.requireTypes.forEach(importTypes::add);
        this.missingTypes.forEach(importTypes::add);
        if (!(this.orProfiles.isEmpty() && this.andProfiles.isEmpty() && this.notProfiles.isEmpty())) {
            importTypes.add("java.util.List");
        }
    }

    boolean isEmpty() {
        return this.orProfiles.isEmpty() && this.andProfiles.isEmpty() && this.notProfiles.isEmpty() && this.requireTypes.isEmpty() && this.missingTypes.isEmpty() && this.qualifierNames.isEmpty() && this.containsProps.isEmpty() && this.missingProps.isEmpty() && this.propertyEquals.isEmpty() && this.propertyNotEquals.isEmpty();
    }
}

