/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.generator;

import java.util.HashSet;
import java.util.Set;

final class IncludeAnnotations {
    private static final String[] EXCLUDED_PREFIX = new String[]{"javax.annotation.", "javax.inject.", "jakarta.annotation.", "jakarta.inject.", "io.avaje.inject.", "lombok."};
    private static final String[] EXCLUDED_SUFFIX = new String[]{".PostConstruct", ".PreDestroy", ".Generated"};
    private static final Set<String> EXCLUDED_ANNOTATIONS = new HashSet<String>();

    IncludeAnnotations() {
    }

    static boolean include(String annotationType) {
        for (String prefix : EXCLUDED_PREFIX) {
            if (!annotationType.startsWith(prefix)) continue;
            return false;
        }
        for (String suffix : EXCLUDED_SUFFIX) {
            if (!annotationType.endsWith(suffix)) continue;
            return false;
        }
        return !EXCLUDED_ANNOTATIONS.contains(annotationType);
    }

    static {
        EXCLUDED_ANNOTATIONS.add("kotlin.Metadata");
        EXCLUDED_ANNOTATIONS.add("io.avaje.http.api.Path");
    }
}

