/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.test.AnnotationReader;
import io.avaje.inject.test.Plugin;
import io.avaje.inject.test.SetupMethods;
import io.avaje.inject.test.TestBeans;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Spy;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.util.reflection.GenericMaster;

final class MetaReader {
    private final SetupMethods methodFinder;
    final List<Field> captors = new ArrayList<Field>();
    final List<FieldTarget> mocks = new ArrayList<FieldTarget>();
    final List<FieldTarget> spies = new ArrayList<FieldTarget>();
    final List<FieldTarget> injection = new ArrayList<FieldTarget>();
    final List<FieldTarget> staticMocks = new ArrayList<FieldTarget>();
    final List<FieldTarget> staticSpies = new ArrayList<FieldTarget>();
    final List<FieldTarget> staticInjection = new ArrayList<FieldTarget>();
    boolean classInjection;
    boolean instanceInjection;
    final Plugin plugin;
    boolean staticPlugin;
    boolean instancePlugin;

    MetaReader(Class<?> testClass, Plugin plugin) {
        this.plugin = plugin;
        LinkedList<Class<?>> hierarchy = MetaReader.typeHierarchy(testClass);
        this.methodFinder = new SetupMethods(hierarchy);
        for (Class clazz : hierarchy) {
            for (Field field : clazz.getDeclaredFields()) {
                this.readField(field);
            }
        }
    }

    boolean hasMocksOrSpies(Object testInstance) {
        if (testInstance == null) {
            return this.hasStaticMocksOrSpies() || this.methodFinder.hasStaticMethods();
        }
        return this.hasInstanceMocksOrSpies(testInstance) || this.methodFinder.hasInstanceMethods();
    }

    private boolean hasInstanceMocksOrSpies(Object testInstance) {
        return !this.mocks.isEmpty() || !this.spies.isEmpty() || this.hasInjectMock(this.injection, testInstance);
    }

    private boolean hasStaticMocksOrSpies() {
        return !this.staticMocks.isEmpty() || !this.staticSpies.isEmpty() || this.hasInjectMock(this.staticInjection, null);
    }

    private boolean hasInjectMock(List<FieldTarget> fields, Object testInstance) {
        for (FieldTarget target : fields) {
            Object existingValue = target.get(testInstance);
            if (existingValue == null) continue;
            return true;
        }
        return false;
    }

    private static LinkedList<Class<?>> typeHierarchy(Class<?> testClass) {
        LinkedList hierarchy = new LinkedList();
        for (Class<?> analyzedClass = testClass; analyzedClass != null && !analyzedClass.equals(Object.class); analyzedClass = analyzedClass.getSuperclass()) {
            hierarchy.addFirst(analyzedClass);
        }
        return hierarchy;
    }

    boolean hasClassInjection() {
        return this.classInjection || this.methodFinder.hasStaticMethods();
    }

    boolean hasInstanceInjection() {
        return this.instanceInjection || this.methodFinder.hasInstanceMethods();
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.toStringAppend("mocks:", this.mocks));
        s.append(this.toStringAppend("spies:", this.spies));
        s.append(this.toStringAppend("inject:", this.injection));
        s.append(this.toStringAppend("captors:", this.captors));
        s.append(this.toStringAppend("staticMocks:", this.staticMocks));
        s.append(this.toStringAppend("staticSpies:", this.staticSpies));
        s.append(this.toStringAppend("staticInjection:", this.staticInjection));
        return s.toString();
    }

    private String toStringAppend(String key, List<?> entries) {
        return entries.isEmpty() ? "" : key + String.valueOf(entries) + "; ";
    }

    private void readField(Field field) {
        Mock mockAnnotation = field.getAnnotation(Mock.class);
        if (mockAnnotation != null) {
            this.add(this.newTarget(field), this.mocks, this.staticMocks);
            return;
        }
        Spy spyAnnotation = field.getAnnotation(Spy.class);
        if (spyAnnotation != null) {
            this.add(this.newTarget(field), this.spies, this.staticSpies);
            return;
        }
        Captor captorAnnotation = field.getAnnotation(Captor.class);
        if (captorAnnotation != null) {
            this.captors.add(field);
            return;
        }
        Inject injectAnnotation = field.getAnnotation(Inject.class);
        if (injectAnnotation != null) {
            FieldTarget target = this.newTarget(field);
            if (this.plugin != null && this.plugin.forType(target.type())) {
                target.markForPluginInjection();
                if (target.isStatic()) {
                    this.staticPlugin = true;
                } else {
                    this.instancePlugin = true;
                }
            }
            this.add(target, this.injection, this.staticInjection);
        }
    }

    private void add(FieldTarget target, List<FieldTarget> instanceList, List<FieldTarget> staticList) {
        if (target.isStatic()) {
            this.classInjection = true;
            staticList.add(target);
        } else {
            this.instanceInjection = true;
            instanceList.add(target);
        }
    }

    private FieldTarget newTarget(Field field) {
        return new FieldTarget(field, this.name(field));
    }

    private String name(Field field) {
        Named named = field.getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        for (Annotation annotation : field.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Annotation metaAnnotation : annotationType.getAnnotations()) {
                if (!metaAnnotation.annotationType().equals(Qualifier.class)) continue;
                return AnnotationReader.simplifyAnnotation(annotation.toString()).replaceFirst(annotationType.getCanonicalName(), annotationType.getSimpleName()).replace("()", "").substring(1);
            }
        }
        return null;
    }

    TestBeans setFromScope(TestBeans metaScope, Object testInstance) {
        if (testInstance != null) {
            return this.setForInstance(metaScope, testInstance);
        }
        return this.setForStatics(metaScope);
    }

    private TestBeans setForInstance(TestBeans metaScope, Object testInstance) {
        try {
            Plugin.Scope pluginScope = metaScope.plugin();
            BeanScope beanScope = metaScope.beanScope();
            for (Field field : this.captors) {
                this.set(field, this.captorFor(field), testInstance);
            }
            for (FieldTarget target : this.mocks) {
                target.setFromScope(beanScope, testInstance);
            }
            for (FieldTarget target : this.spies) {
                target.setFromScope(beanScope, testInstance);
            }
            for (FieldTarget target : this.injection) {
                if (target.pluginInjection) {
                    Object instance = pluginScope.create(target.type());
                    target.setFromPlugin(instance, testInstance);
                    continue;
                }
                target.setFromScope(beanScope, testInstance);
            }
            return metaScope;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private TestBeans setForStatics(TestBeans metaScope) {
        try {
            Plugin.Scope pluginScope = metaScope.plugin();
            BeanScope beanScope = metaScope.beanScope();
            for (FieldTarget target : this.staticMocks) {
                target.setFromScope(beanScope, null);
            }
            for (FieldTarget target : this.staticSpies) {
                target.setFromScope(beanScope, null);
            }
            for (FieldTarget target : this.staticInjection) {
                if (target.pluginInjection) {
                    Object instance = pluginScope.create(target.type());
                    target.setFromPlugin(instance, null);
                    continue;
                }
                target.setFromScope(beanScope, null);
            }
            return metaScope;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object captorFor(Field field) {
        Class<?> type = field.getType();
        if (!ArgumentCaptor.class.isAssignableFrom(type)) {
            throw new IllegalStateException("@Captor field must be of the type ArgumentCaptor.\n Field: '" + field.getName() + "' has wrong type");
        }
        Class cls = new GenericMaster().getGenericType(field);
        return ArgumentCaptor.forClass((Class)cls);
    }

    void build(BeanScopeBuilder builder, Object testInstance) {
        if (testInstance != null) {
            this.buildForInstance(builder, testInstance);
        } else {
            this.buildForStatics(builder);
        }
    }

    void buildForInstance(BeanScopeBuilder builder, Object testInstance) {
        for (FieldTarget target : this.mocks) {
            MetaReader.registerMock(testInstance, builder, target);
        }
        for (FieldTarget target : this.spies) {
            MetaReader.registerSpy(testInstance, builder, target);
        }
        for (FieldTarget target : this.injection) {
            Object existingValue = target.get(testInstance);
            if (existingValue == null) continue;
            MetaReader.registerAsTestDouble(builder, target, existingValue);
        }
        this.methodFinder.invokeInstance(builder, testInstance);
    }

    void buildForStatics(BeanScopeBuilder builder) {
        for (FieldTarget target : this.staticMocks) {
            MetaReader.registerMock(null, builder, target);
        }
        for (FieldTarget target : this.staticSpies) {
            MetaReader.registerSpy(null, builder, target);
        }
        for (FieldTarget target : this.staticInjection) {
            Object existingValue = target.get(null);
            if (existingValue == null) continue;
            MetaReader.registerAsTestDouble(builder, target, existingValue);
        }
        this.methodFinder.invokeStatics(builder);
    }

    private static void registerMock(Object testInstance, BeanScopeBuilder builder, FieldTarget target) {
        Object existingValue = target.get(testInstance);
        if (existingValue != null) {
            MetaReader.registerAsTestDouble(builder, target, existingValue);
        } else {
            builder.forTesting().mock(target.type(), target.name());
        }
    }

    private static void registerSpy(Object testInstance, BeanScopeBuilder builder, FieldTarget target) {
        Object existingValue = target.get(testInstance);
        if (existingValue != null) {
            MetaReader.registerAsTestDouble(builder, target, existingValue);
        } else {
            builder.forTesting().spy(target.type(), target.name());
        }
    }

    private static void registerAsTestDouble(BeanScopeBuilder builder, FieldTarget target, Object value) {
        target.markAsProvided();
        builder.bean(target.name(), target.type(), value);
    }

    void set(Field field, Object val, Object testInstance) throws IllegalAccessException {
        Plugins.getMemberAccessor().set(field, testInstance, val);
    }

    class FieldTarget {
        private final Field field;
        private final String name;
        private final boolean isStatic;
        private boolean pluginInjection;
        private boolean valueAlreadyProvided;

        FieldTarget(Field field, String name) {
            this.field = field;
            this.isStatic = Modifier.isStatic(field.getModifiers());
            this.name = name;
        }

        public String toString() {
            return this.field.getName();
        }

        Type type() {
            return this.field.getGenericType();
        }

        String name() {
            return this.name;
        }

        boolean isStatic() {
            return this.isStatic;
        }

        Object get(Object instance) {
            try {
                return Plugins.getMemberAccessor().get(this.field, instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        void setFromScope(BeanScope beanScope, Object testInstance) throws IllegalAccessException {
            if (!this.valueAlreadyProvided) {
                MetaReader.this.set(this.field, beanScope.get(this.type(), this.name), testInstance);
            }
        }

        void setFromPlugin(Object value, Object testInstance) throws IllegalAccessException {
            MetaReader.this.set(this.field, value, testInstance);
        }

        void markForPluginInjection() {
            this.pluginInjection = true;
        }

        void markAsProvided() {
            this.valueAlreadyProvided = true;
        }
    }
}

