/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.test.GlobalTestBeans;
import io.avaje.inject.test.Plugin;
import io.avaje.inject.test.PluginMgr;
import io.avaje.inject.test.TestModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;
import org.jspecify.annotations.Nullable;

final class GlobalInitialise {
    private static final ReentrantLock lock = new ReentrantLock();
    private static GlobalTestBeans.Beans SCOPE;
    private final boolean shutdownHook;

    static @Nullable BeanScope createTestBaseScope(boolean shutdownHook) {
        return new GlobalInitialise(shutdownHook).build();
    }

    static GlobalTestBeans.Beans initialise(boolean shutdownHook) {
        lock.lock();
        try {
            if (SCOPE == null) {
                SCOPE = GlobalInitialise.createScopes(shutdownHook);
            }
            GlobalTestBeans.Beans beans = SCOPE;
            return beans;
        }
        finally {
            lock.unlock();
        }
    }

    GlobalInitialise(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    private static GlobalTestBeans.Beans createScopes(boolean shutdownHook) {
        BeanScope testBaseScope = GlobalInitialise.createTestBaseScope(shutdownHook);
        BeanScope testAllScope = GlobalInitialise.createTestAllScope(testBaseScope);
        Plugin.Scope pluginAll = PluginMgr.scope(testAllScope);
        return new GlobalTestBeans.Beans(pluginAll, testAllScope, testBaseScope);
    }

    private static BeanScope createTestAllScope(BeanScope testBaseScope) {
        return BeanScope.builder().parent(testBaseScope, false).build();
    }

    private @Nullable BeanScope build() {
        ArrayList<TestModule> testModules = new ArrayList<TestModule>();
        for (TestModule next : ServiceLoader.load(TestModule.class)) {
            testModules.add(next);
        }
        if (testModules.isEmpty()) {
            return this.buildFromResources();
        }
        return this.buildFromModules(testModules);
    }

    private BeanScope buildFromModules(List<TestModule> testModules) {
        return BeanScope.builder().modules((AvajeModule[])testModules.toArray(AvajeModule[]::new)).shutdownHook(this.shutdownHook).build();
    }

    private @Nullable BeanScope buildFromResources() {
        try {
            LinkedHashSet testModuleClasses = new LinkedHashSet();
            Enumeration<URL> urls = ClassLoader.getSystemResources("META-INF/services/io.avaje.inject.test.TestModule");
            while (urls.hasMoreElements()) {
                String className = this.readServiceClassName(urls.nextElement());
                if (className == null) continue;
                testModuleClasses.add(Class.forName(className));
            }
            ArrayList<TestModule> testModules = new ArrayList<TestModule>();
            for (Class clazz : testModuleClasses) {
                testModules.add((TestModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            return testModules.isEmpty() ? null : this.buildFromModules(testModules);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error trying to create TestModule", e);
        }
    }

    private @Nullable String readServiceClassName(URL url) throws IOException {
        InputStream is;
        if (url != null && (is = url.openStream()) != null) {
            try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(is));){
                String string = lineNumberReader.readLine();
                return string;
            }
        }
        return null;
    }
}

