/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.applog.AppLog;
import io.avaje.inject.BeanScope;
import io.avaje.inject.test.InjectExtension;
import io.avaje.inject.test.TestBeanScope;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.ExtensionContext;

final class GlobalTestScope
implements ExtensionContext.Store.CloseableResource {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.inject");
    private final ReentrantLock lock = new ReentrantLock();
    private boolean started;
    private BeanScope globalBeanScope;

    GlobalTestScope() {
    }

    BeanScope obtain(ExtensionContext context) {
        this.lock.lock();
        try {
            if (!this.started) {
                this.initialise(context);
                this.started = true;
            }
            BeanScope beanScope = this.globalBeanScope;
            return beanScope;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initialise(ExtensionContext context) {
        this.globalBeanScope = TestBeanScope.init(false);
        if (this.globalBeanScope != null) {
            log.log(System.Logger.Level.TRACE, "register global test BeanScope with beans {0}", this.globalBeanScope);
            context.getRoot().getStore(ExtensionContext.Namespace.GLOBAL).put((Object)InjectExtension.class.getCanonicalName(), (Object)this);
        }
    }

    public void close() {
        this.lock.lock();
        try {
            if (this.globalBeanScope != null) {
                log.log(System.Logger.Level.DEBUG, "Closing global test BeanScope");
                this.globalBeanScope.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

