/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.Module;
import io.avaje.inject.test.TestModule;
import io.avaje.lang.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.locks.ReentrantLock;

final class TSBuild {
    private static final ReentrantLock lock = new ReentrantLock();
    private static BeanScope SCOPE;
    private final boolean shutdownHook;

    @Nullable
    static BeanScope create(boolean shutdownHook) {
        return new TSBuild(shutdownHook).build();
    }

    @Nullable
    static BeanScope initialise(boolean shutdownHook) {
        lock.lock();
        try {
            if (SCOPE == null) {
                SCOPE = TSBuild.create(shutdownHook);
            }
            BeanScope beanScope = SCOPE;
            return beanScope;
        }
        finally {
            lock.unlock();
        }
    }

    TSBuild(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
    }

    @Nullable
    private BeanScope build() {
        ArrayList<TestModule> testModules = new ArrayList<TestModule>();
        for (TestModule next : ServiceLoader.load(TestModule.class)) {
            testModules.add(next);
        }
        if (testModules.isEmpty()) {
            return this.buildFromResources();
        }
        return this.buildFromModules(testModules);
    }

    private BeanScope buildFromModules(List<TestModule> testModules) {
        return BeanScope.builder().modules((Module[])testModules.toArray(Module[]::new)).shutdownHook(this.shutdownHook).build();
    }

    @Nullable
    private BeanScope buildFromResources() {
        try {
            LinkedHashSet testModuleClasses = new LinkedHashSet();
            Enumeration<URL> urls = ClassLoader.getSystemResources("META-INF/services/io.avaje.inject.test.TestModule");
            while (urls.hasMoreElements()) {
                String className = this.readServiceClassName(urls.nextElement());
                if (className == null) continue;
                testModuleClasses.add(Class.forName(className));
            }
            ArrayList<TestModule> testModules = new ArrayList<TestModule>();
            for (Class clazz : testModuleClasses) {
                testModules.add((TestModule)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            return testModules.isEmpty() ? null : this.buildFromModules(testModules);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error trying to create TestModule", e);
        }
    }

    @Nullable
    private String readServiceClassName(URL url) throws IOException {
        InputStream is;
        if (url != null && (is = url.openStream()) != null) {
            try (LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(is));){
                String string = lineNumberReader.readLine();
                return string;
            }
        }
        return null;
    }
}

