/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.event;

import io.avaje.inject.event.Observer;
import io.avaje.inject.event.ObserverManager;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

public abstract class Event<T> {
    protected final List<Observer<T>> observers;

    protected Event(ObserverManager manager, Type type) {
        this.observers = manager.observersByType(type);
    }

    public void fire(T event, String qualifier) {
        this.observers.stream().sorted(Comparator.comparing(Observer::priority)).forEach(observer -> observer.observe(event, qualifier, false));
    }

    public CompletionStage<T> fireAsync(T event, String qualifier) {
        CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
        return this.observers.stream().sorted(Comparator.comparing(Observer::priority)).reduce(CompletableFuture.completedFuture(null), (future, observer) -> future.thenRun(() -> {
            try {
                observer.observe(event, qualifier, true);
            }
            catch (Exception e) {
                exceptionHandler.handle(e);
            }
        }), (future1, future2) -> future1).thenApply(v -> {
            this.handleExceptions(exceptionHandler);
            return event;
        });
    }

    public void fire(T event) {
        this.fire(event, "");
    }

    public CompletionStage<T> fireAsync(T event) {
        return this.fireAsync(event, "");
    }

    private void handleExceptions(CollectingExceptionHandler handler) {
        List<Exception> handledExceptions = handler.getHandledExceptions();
        if (!handledExceptions.isEmpty()) {
            CompletionException exception = handledExceptions.size() == 1 ? new CompletionException(handledExceptions.get(0)) : new CompletionException(null);
            for (Throwable throwable : handledExceptions) {
                exception.addSuppressed(throwable);
            }
            throw exception;
        }
    }

    private static class CollectingExceptionHandler {
        private final List<Exception> throwables;

        CollectingExceptionHandler() {
            this(new ArrayList<Exception>());
        }

        CollectingExceptionHandler(List<Exception> throwables) {
            this.throwables = throwables;
        }

        public void handle(Exception throwable) {
            this.throwables.add(throwable);
        }

        public List<Exception> getHandledExceptions() {
            return this.throwables;
        }
    }
}

