/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject;

import io.avaje.applog.AppLog;
import io.avaje.inject.BeanScope;
import io.avaje.inject.BeanScopeBuilder;
import io.avaje.inject.DConfigProps;
import io.avaje.inject.DServiceLoader;
import io.avaje.inject.DSystemProps;
import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.Builder;
import io.avaje.inject.spi.ClosePair;
import io.avaje.inject.spi.ConfigPropertyPlugin;
import io.avaje.inject.spi.EnrichBean;
import io.avaje.inject.spi.ModuleOrdering;
import io.avaje.inject.spi.PropertyRequiresPlugin;
import io.avaje.inject.spi.SuppliedBean;
import jakarta.inject.Provider;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

final class DBeanScopeBuilder
implements BeanScopeBuilder.ForTesting {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.inject");
    private final List<SuppliedBean> suppliedBeans = new ArrayList<SuppliedBean>();
    private final List<EnrichBean> enrichBeans = new ArrayList<EnrichBean>();
    private final Set<AvajeModule> includeModules = new LinkedHashSet<AvajeModule>();
    private final List<Runnable> postConstructList = new ArrayList<Runnable>();
    private final List<Consumer<BeanScope>> postConstructConsumerList = new ArrayList<Consumer<BeanScope>>();
    private final List<ClosePair> preDestroyList = new ArrayList<ClosePair>();
    private BeanScope parent;
    private boolean parentOverride = true;
    private boolean shutdownHook;
    private ClassLoader classLoader;
    private ConfigPropertyPlugin propertyPlugin;
    private Set<String> profiles;

    DBeanScopeBuilder() {
    }

    @Override
    public BeanScopeBuilder.ForTesting forTesting() {
        return this;
    }

    @Override
    public BeanScopeBuilder shutdownHook(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
        return this;
    }

    @Override
    public BeanScopeBuilder modules(AvajeModule ... modules) {
        this.includeModules.addAll(Arrays.asList(modules));
        return this;
    }

    @Override
    public PropertyRequiresPlugin propertyPlugin() {
        if (this.propertyPlugin == null) {
            this.propertyPlugin = this.defaultPropertyPlugin();
        }
        return this.propertyPlugin;
    }

    @Override
    public void configPlugin(ConfigPropertyPlugin propertyPlugin) {
        this.propertyPlugin = propertyPlugin;
    }

    @Override
    public ConfigPropertyPlugin configPlugin() {
        if (this.propertyPlugin == null) {
            this.propertyPlugin = this.defaultPropertyPlugin();
        }
        return this.propertyPlugin;
    }

    @Override
    public BeanScopeBuilder beans(Object ... beans) {
        for (Object bean : beans) {
            this.suppliedBeans.add(SuppliedBean.of(DBeanScopeBuilder.superOf(bean.getClass()), bean));
        }
        return this;
    }

    @Override
    public <D> BeanScopeBuilder bean(Class<D> type, D bean) {
        return this.bean(null, type, bean);
    }

    @Override
    public <D> BeanScopeBuilder bean(@Nullable String name, Class<D> type, D bean) {
        this.suppliedBeans.add(SuppliedBean.of(name, type, bean));
        return this;
    }

    @Override
    public <D> BeanScopeBuilder bean(Type type, D bean) {
        return this.bean(null, type, bean);
    }

    @Override
    public <D> BeanScopeBuilder bean(@Nullable String name, Type type, D bean) {
        this.suppliedBeans.add(SuppliedBean.ofType(name, type, bean));
        return this;
    }

    @Override
    public BeanScopeBuilder profiles(String ... profiles) {
        this.profiles = Set.of(profiles);
        return this;
    }

    @Override
    public <D> BeanScopeBuilder provideDefault(@Nullable String name, Type type, Supplier<D> supplier) {
        Provider provider = supplier::get;
        this.suppliedBeans.add(SuppliedBean.secondary(name, type, provider));
        return this;
    }

    @Override
    public BeanScopeBuilder addPostConstruct(Runnable postConstructHook) {
        this.postConstructList.add(postConstructHook);
        return this;
    }

    @Override
    public BeanScopeBuilder addPostConstruct(Consumer<BeanScope> postConstructConsumer) {
        this.postConstructConsumerList.add(postConstructConsumer);
        return this;
    }

    @Override
    public BeanScopeBuilder addPreDestroy(AutoCloseable preDestroyHook) {
        return this.addPreDestroy(preDestroyHook, 1000);
    }

    @Override
    public BeanScopeBuilder addPreDestroy(AutoCloseable preDestroyHook, int priority) {
        this.preDestroyList.add(new ClosePair(priority, preDestroyHook));
        return this;
    }

    @Override
    public BeanScopeBuilder classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public BeanScopeBuilder parent(BeanScope parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public BeanScopeBuilder parent(BeanScope parent, boolean parentOverride) {
        this.parent = parent;
        this.parentOverride = parentOverride;
        return this;
    }

    @Override
    public BeanScopeBuilder.ForTesting mock(Type type) {
        return this.mock(type, null);
    }

    @Override
    public BeanScopeBuilder.ForTesting mock(Type type, String name) {
        this.suppliedBeans.add(SuppliedBean.ofType(name, type, null));
        return this;
    }

    @Override
    public <D> BeanScopeBuilder.ForTesting mock(Class<D> type, Consumer<D> consumer) {
        return this.mock(type, null, consumer);
    }

    private <D> BeanScopeBuilder.ForTesting mock(Class<D> type, @Nullable String name, @Nullable Consumer<D> consumer) {
        this.suppliedBeans.add(SuppliedBean.of(name, type, consumer));
        return this;
    }

    @Override
    public BeanScopeBuilder.ForTesting spy(Type type) {
        return this.spy(type, null, null);
    }

    @Override
    public BeanScopeBuilder.ForTesting spy(Type type, String name) {
        return this.spy(type, name, null);
    }

    @Override
    public <D> BeanScopeBuilder.ForTesting spy(Class<D> type, Consumer<D> consumer) {
        return this.spy(type, null, consumer);
    }

    private <D> BeanScopeBuilder.ForTesting spy(Class<D> type, @Nullable String name, @Nullable Consumer<D> consumer) {
        this.enrichBeans.add(new EnrichBean<D>(type, name, consumer));
        return this;
    }

    private <D> BeanScopeBuilder.ForTesting spy(Type type, @Nullable String name, @Nullable Consumer<D> consumer) {
        this.enrichBeans.add(new EnrichBean<D>(type, name, consumer));
        return this;
    }

    private void initClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    private ConfigPropertyPlugin defaultPropertyPlugin() {
        return this.detectAvajeConfig() ? new DConfigProps() : new DSystemProps();
    }

    private boolean detectAvajeConfig() {
        if (ModuleLayer.boot().findModule("io.avaje.config").isPresent()) {
            return true;
        }
        try {
            Class.forName("io.avaje.config.Configuration", false, this.classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void initProfiles() {
        if (this.profiles == null) {
            this.profiles = this.propertyPlugin.get("avaje.profiles").map(p -> Set.of(p.split(","))).orElse(Collections.emptySet());
        }
    }

    @Override
    public BeanScope build() {
        long start = System.currentTimeMillis();
        this.initClassLoader();
        DServiceLoader serviceLoader = new DServiceLoader(this.classLoader);
        if (this.propertyPlugin == null) {
            this.propertyPlugin = serviceLoader.propertyPlugin().orElseGet(this::defaultPropertyPlugin);
        }
        serviceLoader.plugins().forEach(plugin -> plugin.apply(this));
        ModuleOrdering factoryOrder = new FactoryOrder(this.parent, this.includeModules, !this.suppliedBeans.isEmpty());
        if (factoryOrder.isEmpty()) {
            factoryOrder = serviceLoader.moduleOrdering().orElse(factoryOrder);
            serviceLoader.modules().forEach(factoryOrder::add);
        }
        Set<String> moduleNames = factoryOrder.orderModules();
        System.Logger.Level level = this.propertyPlugin.contains("printModules") ? System.Logger.Level.INFO : System.Logger.Level.DEBUG;
        this.initProfiles();
        log.log(level, "building with avaje modules {0} profiles {1}", moduleNames, this.profiles);
        Builder builder = Builder.newBuilder(this.profiles, this.propertyPlugin, this.suppliedBeans, this.enrichBeans, this.parent, this.parentOverride);
        for (AvajeModule factory : factoryOrder.factories()) {
            builder.currentModule(factory.getClass());
            factory.build(builder);
        }
        if (moduleNames.isEmpty()) {
            log.log(System.Logger.Level.ERROR, "Could not find any AvajeModule instances to wire. Possible Causes: \n1. No beans have been defined.\n2. The avaje-inject-generator depedency was not available during compilation\n3. Perhaps using Gradle and a misconfigured IDE? Refer to https://avaje.io/inject#gradle");
        }
        this.postConstructList.forEach(builder::addPostConstruct);
        this.postConstructConsumerList.forEach(builder::addPostConstruct);
        for (ClosePair closePair : this.preDestroyList) {
            builder.addPreDestroy(closePair.closeable(), closePair.priority());
        }
        return builder.build(this.shutdownHook, start);
    }

    private static Class<?> superOf(Class<?> suppliedClass) {
        Class<?> suppliedSuper = suppliedClass.getSuperclass();
        if (Object.class.equals(suppliedSuper)) {
            return suppliedClass;
        }
        return suppliedSuper;
    }

    static class FactoryOrder
    implements ModuleOrdering {
        private final BeanScope parent;
        private final boolean suppliedBeans;
        private final Set<String> moduleNames = new LinkedHashSet<String>();
        private final List<AvajeModule> factories = new ArrayList<AvajeModule>();
        private final List<FactoryState> queue = new ArrayList<FactoryState>();
        private final List<FactoryState> queueNoDependencies = new ArrayList<FactoryState>();
        private final Map<String, FactoryList> providesMap = new HashMap<String, FactoryList>();

        FactoryOrder(BeanScope parent, Set<AvajeModule> includeModules, boolean suppliedBeans) {
            this.parent = parent;
            this.factories.addAll(includeModules);
            this.suppliedBeans = suppliedBeans;
            for (AvajeModule includeModule : includeModules) {
                this.moduleNames.add(includeModule.getClass().getName());
            }
        }

        @Override
        public void add(AvajeModule module) {
            FactoryState factoryState = new FactoryState(module);
            this.providesMap.computeIfAbsent(module.getClass().getTypeName(), s -> new FactoryList()).add(factoryState);
            this.addFactoryProvides(factoryState, module.provides());
            this.addFactoryProvides(factoryState, module.autoProvides());
            this.addFactoryProvides(factoryState, module.autoProvidesAspects());
            if (factoryState.isRequiresEmpty()) {
                if (factoryState.explicitlyProvides()) {
                    this.push(factoryState);
                } else {
                    this.queueNoDependencies.add(factoryState);
                }
            } else {
                this.queue.add(factoryState);
            }
        }

        private void addFactoryProvides(FactoryState factoryState, Type[] provides) {
            for (Type feature : provides) {
                this.providesMap.computeIfAbsent(feature.getTypeName(), s -> new FactoryList()).add(factoryState);
            }
        }

        private void push(FactoryState factory) {
            factory.setPushed();
            this.factories.add(factory.factory());
            this.moduleNames.add(factory.factory().getClass().getName());
        }

        @Override
        public Set<String> orderModules() {
            for (FactoryState factoryState : this.queueNoDependencies) {
                this.push(factoryState);
            }
            this.processQueue();
            return this.moduleNames;
        }

        @Override
        public List<AvajeModule> factories() {
            return this.factories;
        }

        private void processQueue() {
            int count;
            while ((count = this.processQueuedFactories()) > 0) {
            }
            if (this.suppliedBeans) {
                for (FactoryState factoryState : this.queue) {
                    this.push(factoryState);
                }
            } else if (!this.queue.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (FactoryState factory : this.queue) {
                    sb.append("Module [").append(factory).append("] has unsatisfied");
                    this.unsatisfiedRequires(sb, factory.requires(), "requires");
                    this.unsatisfiedRequires(sb, factory.requiresPackages(), "requiresPackages");
                    this.unsatisfiedRequires(sb, factory.autoRequires(), "autoRequires");
                }
                sb.append(" - none of the loaded modules ").append(this.moduleNames).append(" have this in their @InjectModule( provides = ... ). ");
                if (this.parent != null) {
                    sb.append("The parent BeanScope ").append(this.parent).append(" also does not provide this dependency. ");
                }
                sb.append("Either @InjectModule requires/provides are not aligned? or add external dependencies via BeanScopeBuilder.bean()?");
                throw new IllegalStateException(sb.toString());
            }
        }

        private void unsatisfiedRequires(StringBuilder sb, Type[] requiredType, String requires) {
            for (Type depModuleName : requiredType) {
                if (!this.notProvided(depModuleName.getTypeName())) continue;
                sb.append(String.format(" %s [%s]", requires, depModuleName.getTypeName()));
            }
        }

        private boolean notProvided(String dependency) {
            if (this.parent != null && this.parent.contains(dependency)) {
                return false;
            }
            FactoryList factoryList = this.providesMap.get(dependency);
            return factoryList == null || !factoryList.allPushed();
        }

        private int processQueuedFactories() {
            int count = 0;
            Iterator<FactoryState> it = this.queue.iterator();
            while (it.hasNext()) {
                FactoryState factory = it.next();
                if (!this.satisfiedDependencies(factory)) continue;
                it.remove();
                this.push(factory);
                ++count;
            }
            return count;
        }

        private boolean satisfiedDependencies(FactoryState factory) {
            return this.satisfiedDependencies(factory.requires()) && this.satisfiedDependencies(factory.requiresPackages()) && this.satisfiedDependencies(factory.autoRequiresAspects()) && this.satisfiedDependencies(factory.autoRequires());
        }

        private boolean satisfiedDependencies(Type[] requires) {
            for (Type dependency : requires) {
                if (!this.notProvided(dependency.getTypeName())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.factories.isEmpty();
        }
    }

    private static class FactoryList {
        private final List<FactoryState> factories = new ArrayList<FactoryState>();

        private FactoryList() {
        }

        void add(FactoryState factory) {
            this.factories.add(factory);
        }

        boolean allPushed() {
            for (FactoryState factory : this.factories) {
                if (factory.isPushed()) continue;
                return false;
            }
            return true;
        }
    }

    private static class FactoryState {
        private final AvajeModule factory;
        private boolean pushed;

        private FactoryState(AvajeModule factory) {
            this.factory = factory;
        }

        void setPushed() {
            this.pushed = true;
        }

        boolean isPushed() {
            return this.pushed;
        }

        AvajeModule factory() {
            return this.factory;
        }

        Type[] requires() {
            return this.factory.requires();
        }

        Type[] requiresPackages() {
            return this.factory.requiresPackages();
        }

        Type[] autoRequires() {
            return this.factory.autoRequires();
        }

        Type[] autoRequiresAspects() {
            return this.factory.autoRequiresAspects();
        }

        public String toString() {
            return this.factory.getClass().getTypeName();
        }

        boolean isRequiresEmpty() {
            return this.isEmpty(this.factory.requires()) && this.isEmpty(this.factory.requiresPackages()) && this.isEmpty(this.factory.autoRequires()) && this.isEmpty(this.factory.autoRequiresAspects());
        }

        boolean explicitlyProvides() {
            return !this.isEmpty(this.factory.provides());
        }

        private boolean isEmpty(@Nullable Type[] values) {
            return values == null || values.length == 0;
        }
    }
}

