/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.KeyUtil;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.mockito.Mockito;

public final class EnrichBean<B> {
    private final Type type;
    private final String name;
    private final Consumer<B> consumer;

    public EnrichBean(Type type, String name, Consumer<B> consumer) {
        this.type = type;
        this.name = name;
        this.consumer = consumer;
    }

    public B enrich(B bean) {
        Object spy = Mockito.spy(bean);
        if (this.consumer != null) {
            this.consumer.accept(spy);
        }
        return (B)spy;
    }

    public String key() {
        return KeyUtil.key(this.type, this.name);
    }
}

