/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.DEntry;
import jakarta.inject.Provider;
import java.util.concurrent.locks.ReentrantLock;

class DContextEntryBean {
    protected final Object source;
    protected final String name;
    protected final Class<? extends AvajeModule> sourceModule;
    private final int flag;

    static DContextEntryBean of(Object source, String name, int flag, Class<? extends AvajeModule> currentModule) {
        if (source instanceof Provider) {
            return new ProtoProvider((Provider)source, name, flag, currentModule);
        }
        return new DContextEntryBean(source, name, flag, currentModule);
    }

    static DContextEntryBean supplied(Object source, String name, int flag) {
        if (source instanceof Provider) {
            return new OnceProvider((Provider<?>)((Provider)source), name, flag, null);
        }
        return new DContextEntryBean(source, name, flag, null);
    }

    static DContextEntryBean provider(boolean prototype, Provider<?> provider, String name, int flag, Class<? extends AvajeModule> currentModule) {
        return prototype ? new ProtoProvider(provider, name, flag, currentModule) : new OnceProvider(provider, name, flag, currentModule);
    }

    private DContextEntryBean(Object source, String name, int flag, Class<? extends AvajeModule> currentModule) {
        this.source = source;
        this.name = name;
        this.flag = flag;
        this.sourceModule = currentModule;
    }

    public final String toString() {
        return "Bean{source=" + String.valueOf(this.source) + ", name='" + this.name + "', flag=" + this.flag + ", sourceModule=" + String.valueOf(this.sourceModule) + "}";
    }

    final DEntry entry() {
        return new DEntry(this.name, this.flag, this.bean());
    }

    final boolean isNameMatch(String qualifierName) {
        return qualifierName == null || qualifierName.equalsIgnoreCase(this.name);
    }

    final boolean isNameEqual(String qualifierName) {
        return qualifierName == null ? this.name == null : qualifierName.equalsIgnoreCase(this.name);
    }

    final Class<? extends AvajeModule> sourceModule() {
        return this.sourceModule;
    }

    Object beanIfNameMatch(String name) {
        return this.isNameMatch(name) ? this.bean() : null;
    }

    String name() {
        return this.name;
    }

    Object bean() {
        return this.source;
    }

    Provider<?> provider() {
        return this::bean;
    }

    final boolean isPrimary() {
        return this.flag == 1;
    }

    final boolean isSecondary() {
        return this.flag == -1;
    }

    final boolean isSupplied() {
        return this.flag == 2;
    }

    final boolean isSupplied(String qualifierName) {
        return this.flag == 2 && (qualifierName == null || qualifierName.equals(this.name));
    }

    static final class ProtoProvider
    extends DContextEntryBean {
        private final Provider<?> provider;

        private ProtoProvider(Provider<?> provider, String name, int flag, Class<? extends AvajeModule> currentModule) {
            super(provider, name, flag, currentModule);
            this.provider = provider;
        }

        @Override
        Provider<?> provider() {
            return this.provider;
        }

        @Override
        Object bean() {
            return this.provider.get();
        }
    }

    static final class OnceProvider
    extends DContextEntryBean {
        private final ReentrantLock lock = new ReentrantLock();
        private final Provider<?> provider;
        private Object bean;

        private OnceProvider(Provider<?> provider, String name, int flag, Class<? extends AvajeModule> currentModule) {
            super(provider, name, flag, currentModule);
            this.provider = provider;
        }

        @Override
        Object bean() {
            this.lock.lock();
            try {
                if (this.bean == null) {
                    this.bean = this.provider.get();
                }
                Object object = this.bean;
                return object;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

