/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject;

import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.ConfigPropertyPlugin;
import io.avaje.inject.spi.InjectExtension;
import io.avaje.inject.spi.InjectPlugin;
import io.avaje.inject.spi.ModuleOrdering;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;

final class DServiceLoader {
    private final List<InjectPlugin> plugins = new ArrayList<InjectPlugin>();
    private final List<AvajeModule> modules = new ArrayList<AvajeModule>();
    private ModuleOrdering moduleOrdering;
    private ConfigPropertyPlugin propertyPlugin;

    DServiceLoader(ClassLoader classLoader) {
        for (InjectExtension spi : ServiceLoader.load(InjectExtension.class, classLoader)) {
            if (spi instanceof InjectPlugin) {
                this.plugins.add((InjectPlugin)spi);
                continue;
            }
            if (spi instanceof AvajeModule) {
                this.modules.add((AvajeModule)spi);
                continue;
            }
            if (spi instanceof ModuleOrdering) {
                this.moduleOrdering = (ModuleOrdering)spi;
                continue;
            }
            if (!(spi instanceof ConfigPropertyPlugin)) continue;
            this.propertyPlugin = (ConfigPropertyPlugin)spi;
        }
    }

    List<InjectPlugin> plugins() {
        return this.plugins;
    }

    List<AvajeModule> modules() {
        return this.modules;
    }

    Optional<ModuleOrdering> moduleOrdering() {
        return Optional.ofNullable(this.moduleOrdering);
    }

    Optional<ConfigPropertyPlugin> propertyPlugin() {
        return Optional.ofNullable(this.propertyPlugin);
    }
}

