/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.applog.AppLog;
import io.avaje.inject.BeanEntry;
import io.avaje.inject.BeanScope;
import io.avaje.inject.spi.DBeanMap;
import io.avaje.inject.spi.DContextEntryBean;
import io.avaje.inject.spi.DEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
final class DBeanScope
implements BeanScope {
    private static final System.Logger log = AppLog.getLogger((String)"io.avaje.inject");
    private final ReentrantLock lock = new ReentrantLock();
    private final List<Runnable> postConstruct;
    private final List<Consumer<BeanScope>> postConstructConsumers;
    private final List<AutoCloseable> preDestroy;
    private final DBeanMap beans;
    private final ShutdownHook shutdownHook;
    private final BeanScope parent;
    private boolean shutdown;
    private boolean closed;

    DBeanScope(boolean withShutdownHook, List<AutoCloseable> preDestroy, List<Runnable> postConstruct, List<Consumer<BeanScope>> postConstructConsumers, DBeanMap beans, BeanScope parent) {
        this.preDestroy = preDestroy;
        this.postConstruct = postConstruct;
        this.postConstructConsumers = postConstructConsumers;
        this.beans = beans;
        this.parent = parent;
        if (withShutdownHook) {
            this.shutdownHook = new ShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        } else {
            this.shutdownHook = null;
        }
    }

    public String toString() {
        return "BeanScope{" + String.valueOf(this.beans) + "}";
    }

    @Override
    public List<BeanEntry> all() {
        IdentityHashMap<DContextEntryBean, DEntry> map = new IdentityHashMap<DContextEntryBean, DEntry>();
        if (this.parent != null) {
            ((DBeanScope)this.parent).addAll(map);
        }
        this.addAll(map);
        return new ArrayList<BeanEntry>(map.values());
    }

    void addAll(Map<DContextEntryBean, DEntry> map) {
        this.beans.addAll(map);
    }

    @Override
    public boolean contains(String type) {
        return this.beans.contains(type);
    }

    @Override
    public boolean contains(Type type) {
        return this.beans.contains(type);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.getByType(type, null);
    }

    @Override
    public <T> T get(Class<T> type, @Nullable String name) {
        return this.getByType(type, name);
    }

    @Override
    public <T> T get(Type type, @Nullable String name) {
        return this.getByType(type, name);
    }

    private <T> T getByType(Type type, @Nullable String name) {
        Object bean = this.beans.get(type, name);
        if (bean != null) {
            return bean;
        }
        if (this.parent == null) {
            throw new NoSuchElementException("No bean found for type: " + String.valueOf(type) + " name: " + name);
        }
        return this.parent.get(type, name);
    }

    @Nullable Object getStrict(String name, Type[] types) {
        for (Type type : types) {
            Object match = this.beans.getStrict(type, name);
            if (match == null) continue;
            return match;
        }
        if (this.parent instanceof DBeanScope) {
            DBeanScope dParent = (DBeanScope)this.parent;
            return dParent.getStrict(name, types);
        }
        return null;
    }

    @Override
    public <T> Optional<T> getOptional(Class<T> type) {
        return this.getMaybe(type, null);
    }

    @Override
    public <T> Optional<T> getOptional(Type type, @Nullable String name) {
        return this.getMaybe(type, name);
    }

    private <T> Optional<T> getMaybe(Type type, @Nullable String name) {
        Object bean = this.beans.get(type, name);
        if (bean != null) {
            return Optional.of(bean);
        }
        if (this.parent == null) {
            return Optional.empty();
        }
        return this.parent.getOptional(type, name);
    }

    @Override
    public <T> Map<String, T> map(Type type) {
        return this.beans.map(type, this.parent);
    }

    @Override
    public <T> List<T> list(Class<T> type) {
        return this.listOf(type);
    }

    @Override
    public <T> List<T> list(Type type) {
        return this.listOf(type);
    }

    private <T> List<T> listOf(Type type) {
        List<Object> values = this.beans.all(type);
        if (this.parent == null) {
            return values;
        }
        return DBeanScope.combine(values, this.parent.list(type));
    }

    static <T> List<T> combine(List<T> values, List<T> parentValues) {
        if (values.isEmpty()) {
            return parentValues;
        }
        if (parentValues.isEmpty()) {
            return values;
        }
        values.addAll(parentValues);
        return values;
    }

    @Override
    public <T> List<T> listByPriority(Type type) {
        return this.beans.listByPriority(type);
    }

    @Override
    public List<Object> listByAnnotation(Class<? extends Annotation> annotation) {
        List<Object> values = this.all().stream().filter(entry -> entry.type().isAnnotationPresent(annotation)).map(BeanEntry::bean).collect(Collectors.toList());
        if (this.parent == null) {
            return values;
        }
        return DBeanScope.combine(values, this.parent.listByAnnotation(annotation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBeanScope start(long start) {
        this.lock.lock();
        try {
            log.log(System.Logger.Level.TRACE, "firing postConstruct");
            for (Runnable runnable : this.postConstruct) {
                runnable.run();
            }
            for (Consumer consumer : this.postConstructConsumers) {
                consumer.accept(this);
            }
        }
        finally {
            this.lock.unlock();
        }
        log.log(System.Logger.Level.INFO, "Wired beans in {0}ms", System.currentTimeMillis() - start);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.shutdownHook != null && !this.shutdown) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            if (!this.closed) {
                this.closed = true;
                log.log(System.Logger.Level.TRACE, "firing preDestroy");
                for (AutoCloseable closeable : this.preDestroy) {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        log.log(System.Logger.Level.ERROR, "Error during PreDestroy lifecycle method", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void shutdown() {
        this.lock.lock();
        try {
            this.shutdown = true;
            this.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class ShutdownHook
    extends Thread {
        private final DBeanScope scope;

        ShutdownHook(DBeanScope scope) {
            this.scope = scope;
        }

        @Override
        public void run() {
            this.scope.shutdown();
        }
    }
}

