/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.DContextEntryBean;
import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class DContextEntry {
    private final List<DContextEntryBean> entries = new ArrayList<DContextEntryBean>(5);

    DContextEntry() {
    }

    public String toString() {
        return String.valueOf(this.entries);
    }

    List<DContextEntryBean> entries() {
        return this.entries;
    }

    void add(DContextEntryBean entryBean) {
        this.entries.add(entryBean);
    }

    Provider<?> provider(String name, Class<? extends AvajeModule> currentModule) {
        if (this.entries.size() == 1) {
            return this.entries.get(0).provider();
        }
        return new EntryMatcher(name, currentModule).provider(this.entries);
    }

    Object getStrict(String name) {
        if (this.entries.size() == 1) {
            return this.entries.get(0).beanIfNameMatch(name);
        }
        return new EntryMatcher(name, null).match(this.entries);
    }

    Object get(String name, Class<? extends AvajeModule> currentModule) {
        if (this.entries.size() == 1) {
            return this.entries.get(0).bean();
        }
        return new EntryMatcher(name, currentModule).match(this.entries);
    }

    List<Object> all() {
        ArrayList<Object> list = new ArrayList<Object>(this.entries.size());
        for (DContextEntryBean entry : this.entries) {
            list.add(entry.bean());
        }
        return list;
    }

    Map<String, Object> map() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (DContextEntryBean entry : this.entries) {
            Object bean = entry.bean();
            Object nm = entry.name();
            if (nm == null) {
                nm = "$Unnamed-" + System.identityHashCode(bean) + "-" + String.valueOf(bean);
            }
            map.put((String)nm, bean);
        }
        return map;
    }

    DContextEntryBean supplied(String qualifierName) {
        for (DContextEntryBean entry : this.entries) {
            if (!entry.isSupplied(qualifierName)) continue;
            return entry;
        }
        return null;
    }

    static final class EntryMatcher {
        private final String name;
        private final boolean impliedName;
        private final Class<? extends AvajeModule> currentModule;
        private DContextEntryBean match;
        private DContextEntryBean ignoredSecondaryMatch;

        EntryMatcher(String name, Class<? extends AvajeModule> currentModule) {
            this.currentModule = currentModule;
            if (name != null && name.startsWith("!")) {
                this.name = name.substring(1);
                this.impliedName = true;
            } else {
                this.name = name;
                this.impliedName = false;
            }
        }

        private Provider<?> provider(List<DContextEntryBean> entries) {
            DContextEntryBean foundMatch = this.findMatch(entries);
            return foundMatch == null ? null : foundMatch.provider();
        }

        private Object match(List<DContextEntryBean> entries) {
            DContextEntryBean foundMatch = this.findMatch(entries);
            return foundMatch == null ? null : foundMatch.bean();
        }

        private DContextEntryBean findMatch(List<DContextEntryBean> entries) {
            for (DContextEntryBean entry : entries) {
                if (!entry.isNameEqual(this.name)) continue;
                this.checkMatch(entry);
            }
            if (this.match == null && this.impliedName) {
                for (DContextEntryBean entry : entries) {
                    if (!entry.isNameEqual(null)) continue;
                    this.checkMatch(entry);
                }
            }
            if (this.match == null && (this.name == null || this.impliedName)) {
                for (DContextEntryBean entry : entries) {
                    this.checkMatch(entry);
                }
            }
            return this.candidate();
        }

        private void checkMatch(DContextEntryBean entry) {
            if (this.match == null) {
                this.match = entry;
                return;
            }
            if (this.match.priority() < entry.priority()) {
                return;
            }
            if (this.match.priority() > entry.priority()) {
                this.match = entry;
                return;
            }
            if (this.match.isPrimary()) {
                if (entry.isPrimary()) {
                    throw new IllegalStateException("Expecting only 1 bean match but have multiple primary beans " + String.valueOf(this.match.bean()) + " and " + String.valueOf(entry.bean()));
                }
                return;
            }
            if (this.impliedName) {
                this.ignoredSecondaryMatch = entry;
                return;
            }
            if (this.match.isNameEqual(this.name) && !entry.isNameEqual(this.name)) {
                this.ignoredSecondaryMatch = entry;
                return;
            }
            if (!this.match.isNameEqual(this.name) && entry.isNameEqual(this.name)) {
                this.match = entry;
                return;
            }
            if (entry.sourceModule() != this.currentModule) {
                this.ignoredSecondaryMatch = entry;
                return;
            }
            if (entry.sourceModule() == this.currentModule && this.match.sourceModule() != this.currentModule) {
                this.match = entry;
                return;
            }
            throw new IllegalStateException("Expecting only 1 bean match but have multiple matching beans " + String.valueOf(this.match.bean()) + " and " + String.valueOf(entry.bean()) + ". Maybe need a rebuild is required after adding a @Named qualifier or @Priority annotation?");
        }

        private DContextEntryBean candidate() {
            if (this.match == null) {
                return null;
            }
            this.checkSecondary();
            return this.match;
        }

        private void checkSecondary() {
            if (this.match.priority() != Integer.MIN_VALUE && this.match.priority() != 0 && this.ignoredSecondaryMatch != null && this.ignoredSecondaryMatch.priority() == this.match.priority()) {
                throw new IllegalStateException("Expecting only 1 bean match but have multiple beans with the same priority" + String.valueOf(this.match.bean()) + " and " + String.valueOf(this.ignoredSecondaryMatch.bean()) + ". Maybe need a rebuild is required after adding a @Named qualifier or @Priority annotation?");
            }
        }
    }
}

