/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.spi;

import io.avaje.inject.spi.AvajeModule;
import io.avaje.inject.spi.DEntry;
import io.avaje.inject.spi.OnceProvider;
import jakarta.inject.Provider;

class DContextEntryBean {
    protected final Object source;
    protected final String name;
    protected final Class<? extends AvajeModule> sourceModule;
    private final int priority;

    static DContextEntryBean of(Object source, String name, int priority, Class<? extends AvajeModule> currentModule) {
        if (source instanceof Provider) {
            return new ProtoProvider((Provider)source, name, priority, currentModule);
        }
        return new DContextEntryBean(source, name, priority, currentModule);
    }

    static DContextEntryBean supplied(Object source, String name, int priority) {
        if (source instanceof Provider) {
            return new OnceBeanProvider((Provider<?>)((Provider)source), name, priority, null);
        }
        return new DContextEntryBean(source, name, priority, null);
    }

    static DContextEntryBean provider(boolean prototype, Provider<?> provider, String name, int flag, Class<? extends AvajeModule> currentModule) {
        return prototype ? new ProtoProvider(provider, name, flag, currentModule) : new OnceBeanProvider(provider, name, flag, currentModule);
    }

    private DContextEntryBean(Object source, String name, int priority, Class<? extends AvajeModule> currentModule) {
        this.source = source;
        this.name = name;
        this.priority = priority;
        this.sourceModule = currentModule;
    }

    public final String toString() {
        return "Bean{source=" + String.valueOf(this.source) + ", name='" + this.name + "', priority=" + this.priority + ", sourceModule=" + String.valueOf(this.sourceModule) + "}";
    }

    final DEntry entry() {
        return new DEntry(this.name, this.priority, this.bean());
    }

    final boolean isNameMatch(String qualifierName) {
        return qualifierName == null || qualifierName.equalsIgnoreCase(this.name);
    }

    final boolean isNameEqual(String qualifierName) {
        return qualifierName == null ? this.name == null : qualifierName.equalsIgnoreCase(this.name);
    }

    final Class<? extends AvajeModule> sourceModule() {
        return this.sourceModule;
    }

    Object beanIfNameMatch(String name) {
        return this.isNameMatch(name) ? this.bean() : null;
    }

    String name() {
        return this.name;
    }

    Object bean() {
        return this.source;
    }

    Provider<?> provider() {
        return this::bean;
    }

    final boolean isPrimary() {
        return this.priority == -2147483647;
    }

    final int priority() {
        return this.priority;
    }

    final boolean isSupplied(String qualifierName) {
        return this.priority == Integer.MIN_VALUE && (qualifierName == null || qualifierName.equals(this.name));
    }

    static final class ProtoProvider
    extends DContextEntryBean {
        private final Provider<?> provider;

        private ProtoProvider(Provider<?> provider, String name, int flag, Class<? extends AvajeModule> currentModule) {
            super(provider, name, flag, currentModule);
            this.provider = provider;
        }

        @Override
        Provider<?> provider() {
            return this.provider;
        }

        @Override
        Object bean() {
            return this.provider.get();
        }
    }

    static final class OnceBeanProvider
    extends DContextEntryBean {
        private final Provider<?> provider;

        private OnceBeanProvider(Provider<?> provider, String name, int flag, Class<? extends AvajeModule> currentModule) {
            super(provider, name, flag, currentModule);
            this.provider = new OnceProvider(provider);
        }

        @Override
        Object bean() {
            return this.provider.get();
        }
    }
}

